% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbxml_handle.R
\name{df2SQLite}
\alias{df2SQLite}
\title{Store drugbank dataframe into an SQLite database}
\usage{
df2SQLite(dbdf, version, dest_dir = ".")
}
\arguments{
\item{dbdf}{Drugbank dataframe generated by \code{\link{dbxml2df}} function.}

\item{version}{Character(1), version of the input drugbank dataframe generated 
by \code{\link{dbxml2df}} function}

\item{dest_dir}{Character(1), destination directory that the result SQLite 
database stored in. The default is user's current working directory}
}
\value{
SQLite database named as "drugbank_<versionNumber>.db" stored under user's 
present working directory of R session or user's specified directory.
}
\description{
Store specific version of drugbank dataframe into an SQLite database 
under user defined directory, the default is user's present working directory 
of R session
}
\examples{
library(RSQLite)
\dontrun{
# download the original drugbank database (http://www.drugbank.ca/releases/latest) (xml file) 
# to your current R working directory, and rename as "drugbank.xml".
# Read in the xml file and convert to a data.frame in R 

drugbank_df = dbxml2df(xmlfile="drugbank.xml", version="5.1.5")

# store the converted drugbank dataframe into SQLite database under user's
present R working direcotry, or other directory defined by 'dest_dir'

df2SQLite(dbdf=drugbank_df, version="5.1.5") # set version as version of xml file
}
}
\seealso{
\code{\link{dbxml2df}}
}
\author{
Yuzhu Duan \url{yduan004@ucr.edu}
}
