% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{IFNCellCounts}
\alias{IFNCellCounts}
\alias{info}
\alias{df_cellCounts}
\alias{hcl}
\title{Cell counts following interferon treatment}
\format{
\itemize{
	\item \code{info} is metadata for each sample
	\item \code{df_cellCounts} data.frame of counts for each sample
	\item \code{hcl} cluster of cell types based on pseudobulk expression
}

An object of class \code{data.frame} with 16 rows and 4 columns.

An object of class \code{matrix} (inherits from \code{array}) with 16 rows and 8 columns.

An object of class \code{hclust} of length 7.
}
\usage{
data(IFNCellCounts)

info

df_cellCounts

hcl
}
\description{
Counts are from single cell RNA-seq data from treated and untreated samples from Kang, et al (2018).
}
\references{
Kang, Hyun Min, et al. "Multiplexed droplet single-cell RNA-sequencing using natural genetic variation." Nature Biotechnology 36.1 (2018): 89-94.
}
\keyword{datasets}
