% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMITScores.R
\name{getMITScores}
\alias{getMITScores}
\title{Calculate MIT off-target specificity scores for CRISPR/Cas9}
\usage{
getMITScores(spacers, protospacers, pams, includeDistance = TRUE)
}
\arguments{
\item{spacers}{Character vector of 20bp spacer sequences.}

\item{protospacers}{Character vector of 20bp protospacer sequences 
for off-targets.}

\item{pams}{Character vector of 3nt PAM sequences.}

\item{includeDistance}{Should distance between mismatches be considered
during scoring? TRUE by default.}
}
\value{
\strong{getMITScores} returns a data.frame with \code{spacer},
    \code{protospacer}, and \code{score} columns. The MIT score takes on a
    value between 0 and 1. For a given pair (on-target, off-target), a 
    higher MIT score indicates a higher likelihood for the Cas9 nuclease to
    cut at the off-target. Non-canonical PAM sequences are taken into account
    by the MIT algorithm.
}
\description{
Calculate MIT off-target specificity scores for CRISPR/Cas9.
}
\examples{
# Calculating MIT scores for two off-targets with respect to
# one spacer sequence:
spacer <- "AGGTGTAGTGTGTGTGATAA"
protospacer1 <- "CGGTGTAGTGTGTGTGATAA"
protospacer2 <- "CGGTGTCGTGTGTGTGATAA"
pams <- c("AGG", "CGG")
results <- getMITScores(spacers=spacer,
    protospacers=c(protospacer1, protospacer2),
    pams=pams
)

}
\references{
Hsu, P., Scott, D., Weinstein, J. et al. DNA targeting
    specificity of RNA-guided Cas9 nucleases.
    Nat Biotechnol 31, 827–832 (2013).
    \url{https://doi.org/10.1038/nbt.2647}.
}
\author{
Jean-Philippe Fortin
}
