% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/addOnTargetScores.R
\name{addOnTargetScores}
\alias{addOnTargetScores}
\alias{addOnTargetScores,GuideSet-method}
\alias{addOnTargetScores,PairedGuideSet-method}
\alias{addOnTargetScores,NULL-method}
\title{Add on-target scores to a \linkS4class{GuideSet} object.}
\usage{
addOnTargetScores(object, ...)

\S4method{addOnTargetScores}{GuideSet}(
  object,
  enzyme = c("WT", "ESP", "HF"),
  promoter = c("U6", "T7"),
  tracrRNA = c("Hsu2013", "Chen2013"),
  directRepeat = "aacccctaccaactggtcggggtttgaaac",
  binaries = NULL,
  methods = c("azimuth", "ruleset1", "ruleset3", "lindel", "deepcpf1", "deephf",
    "deepspcas9", "enpamgb", "casrxrf", "crisprater", "crisprscan")
)

\S4method{addOnTargetScores}{PairedGuideSet}(
  object,
  enzyme = c("WT", "ESP", "HF"),
  promoter = c("U6", "T7"),
  tracrRNA = c("Hsu2013", "Chen2013"),
  directRepeat = "aacccctaccaactggtcggggtttgaaac",
  binaries = NULL,
  methods = c("azimuth", "ruleset1", "ruleset3", "lindel", "deepcpf1", "deephf",
    "deepspcas9", "enpamgb", "crisprater", "crisprscan", "casrxrf")
)

\S4method{addOnTargetScores}{NULL}(object)
}
\arguments{
\item{object}{A \linkS4class{GuideSet} object or a 
\linkS4class{PairedGuideSet} object.}

\item{...}{Additional arguments, currently ignored.}

\item{enzyme}{Character string specifying the Cas9 variant to be used
for DeepHF scoring. Wildtype Cas9 (WT) by default. See details below.}

\item{promoter}{Character string speciyfing promoter used for expressing 
sgRNAs for wildtype Cas9 (must be either "U6" or "T7") for DeepHF
scoring. "U6" by default.}

\item{tracrRNA}{String specifying which tracrRNA is used for SpCas9
Must be either "Hsu2013" (default) or "Chen2013". Only used for
the RuleSet3 method.}

\item{directRepeat}{String specifying the direct repeat used in the 
CasRx construct.}

\item{binaries}{Named list of paths for binaries needed for 
CasRx-RF. Names of the list must be "RNAfold", "RNAhybrid",
and "RNAplfold". Each list element is a string specifying
the path of the binary. If NULL (default), binaries must be
available on the PATH.}

\item{methods}{Character vector specifying method names for on-target
efficiency prediction algorithms.}
}
\value{
\code{guideSet} with columns of on-target scores appended in
    \code{mcols(guideSet)}.
}
\description{
Add on-target scores to a \linkS4class{GuideSet} object
   for all methods available in the \pkg{crisprScore} package for a given
   CRISPR nuclease. Requires \pkg{crisprScore} package to be installed.
}
\details{
See \pkg{crisprScore} package for a description of each score.
}
\examples{
if (interactive()){
    gs <- findSpacers("CCAACATAGTGAAACCACGTCTCTATAAAGAATAAAAAATTAGCCGGGTTA")
    gs <- addOnTargetScores(gs)
}

}
\seealso{
\code{\link{addOffTargetScores}} to add off-target scores.
}
\author{
Jean-Philippe Fortin, Luke Hoberecht
}
