% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/PairedGuideSet-class.R
\docType{class}
\name{pamOrientation}
\alias{pamOrientation}
\alias{pamDistance}
\alias{spacerDistance}
\alias{cutLength}
\alias{PairedGuideSet-class}
\alias{PairedGuideSet}
\alias{pamOrientation,PairedGuideSet-method}
\alias{pamDistance,PairedGuideSet-method}
\alias{spacerDistance,PairedGuideSet-method}
\alias{cutLength,PairedGuideSet-method}
\alias{crisprNuclease,PairedGuideSet-method}
\alias{spacers,PairedGuideSet-method}
\alias{pams,PairedGuideSet-method}
\alias{pamSites,PairedGuideSet-method}
\alias{cutSites,PairedGuideSet-method}
\alias{protospacers,PairedGuideSet-method}
\alias{spacerLength,PairedGuideSet-method}
\alias{pamLength,PairedGuideSet-method}
\alias{pamSide,PairedGuideSet-method}
\title{An S4 class to store pairs of CRISPR gRNA sequences.}
\usage{
pamOrientation(object, ...)

pamDistance(object, ...)

spacerDistance(object, ...)

cutLength(object, ...)

PairedGuideSet(GuideSet1 = NULL, GuideSet2 = NULL)

\S4method{pamOrientation}{PairedGuideSet}(object)

\S4method{pamDistance}{PairedGuideSet}(object)

\S4method{spacerDistance}{PairedGuideSet}(object)

\S4method{cutLength}{PairedGuideSet}(object)

\S4method{crisprNuclease}{PairedGuideSet}(object, index = NULL)

\S4method{spacers}{PairedGuideSet}(object, as.character = FALSE, returnAsRna = FALSE, index = NULL)

\S4method{pams}{PairedGuideSet}(object, as.character = FALSE, returnAsRna = FALSE, index = NULL)

\S4method{pamSites}{PairedGuideSet}(object, index = NULL)

\S4method{cutSites}{PairedGuideSet}(object, index = NULL)

\S4method{protospacers}{PairedGuideSet}(
  object,
  as.character = FALSE,
  include.pam = FALSE,
  returnAsRna = FALSE,
  index = NULL
)

\S4method{spacerLength}{PairedGuideSet}(object, index = NULL)

\S4method{pamLength}{PairedGuideSet}(object, index = NULL)

\S4method{pamSide}{PairedGuideSet}(object, index = NULL)
}
\arguments{
\item{object}{\linkS4class{PairedGuideSet} object.}

\item{...}{Additional arguments for class-specific methods}

\item{GuideSet1}{A \linkS4class{GuideSet} object containing gRNAs at
the first position of the pairs.}

\item{GuideSet2}{A \linkS4class{GuideSet} object containing gRNAs at
the second position of the pairs.}

\item{index}{Integer value indicating gRNA position.
Must be either 1, 2, or NULL (default).
If NULL, both positions are returned.}

\item{as.character}{Should sequences be returned as a character
vector? FALSE by default, in which case sequences are returned
as a \linkS4class{DNAStringSet}.}

\item{returnAsRna}{Should the sequences be returned as RNA
instead of DNA? FALSE by default.}

\item{include.pam}{Should PAM sequences be included?
FALSE by default.}
}
\value{
A PairedGuideSet object.
}
\description{
An S4 class to store pairs of CRISPR gRNA sequences.
}
\section{Functions}{
\itemize{
\item \code{PairedGuideSet()}: Create a \linkS4class{PairedGuideSet} object

}}
\section{Constructors}{

    Use the constructor \code{link{PairedGuideSet}} to create a
    PairedGuideSet object.
}

\examples{
library(crisprDesign)
data(guideSetExample, package="crisprDesign")
gs <- guideSetExample
gs <- gs[order(BiocGenerics::start(gs))]
gs1 <- gs[1:10]
gs2 <- gs[1:10+10]
pgs <- PairedGuideSet(gs1, gs2)
}
