% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runCrisprBwa.R
\name{runCrisprBwa}
\alias{runCrisprBwa}
\title{Find gRNA spacer alignments with bwa}
\usage{
runCrisprBwa(
  spacers,
  bwa_index = NULL,
  bsgenome = NULL,
  crisprNuclease = NULL,
  canonical = TRUE,
  ignore_pam = FALSE,
  n_mismatches = 0,
  force_spacer_length = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{spacers}{Character vector of DNA sequences corresponding
to gRNA spacer sequences. Must all be of equal length.}

\item{bwa_index}{Path to the bwa index to be used for alignment.}

\item{bsgenome}{BSgenome object.}

\item{crisprNuclease}{\code{CrisprNuclease} object.}

\item{canonical}{Should only canonical PAM sequences be considered?
TRUE by default.}

\item{ignore_pam}{If TRUE, will return all matches regardless of
PAM sequence. FALSE by default.}

\item{n_mismatches}{Integer specifying maximum
number of mismatches allowed between spacer and protospacer sequences.}

\item{force_spacer_length}{Should the spacer length be overwritten in the
crisprNuclease object? FALSE by default.}

\item{verbose}{Should messages be printed to the consolde? TRUE by default.}
}
\value{
\strong{runBwa} returns spacer alignment data, including genomic 
    coordinates and sequence.
}
\description{
Return bwa alignments for a list of gRNA spacer sequences.
}
\details{
\code{runCrisprBwa} is similar to \code{runBwa}, with the 
    addition of imposing constraints on PAM sequences such that the query
    sequences are valid protospacer sequences in the searched genome.
}
\examples{

# Building BWA index first:
fasta <- system.file(package="crisprBwa", "example/chr12.fa")
outdir <- tempdir()
index <- file.path(outdir, "chr12")
Rbwa::bwa_build_index(fasta,
                      index_prefix=index)


# Aligning Cas9 gRNA
library(BSgenome.Hsapiens.UCSC.hg38)
seqs <- c("AGCTGTCCGTGGGGGTCCGC",
          "CCCCTGCTGCTGTGCCAGGC")
data(SpCas9, package="crisprBase")
bsgenome <- BSgenome.Hsapiens.UCSC.hg38
results <- runCrisprBwa(seqs,
                        bsgenome=bsgenome,
                        bwa_index=index,
                        n_mismatches=2,
                        crisprNuclease=SpCas9)

}
\seealso{
\code{link{runBwa}} to map general DNA sequences.
}
\author{
Jean-Philippe Fortin
}
