% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateStats.R
\name{calculateStats}
\alias{calculateStats}
\title{Calculate statistics for pairwise comparison of data sets}
\usage{
calculateStats(
  df,
  ds1,
  ds2,
  column,
  subsampleSize,
  permute = FALSE,
  kmin,
  kfrac,
  xmin,
  xmax
)
}
\arguments{
\item{df}{The input data frame. Must contain at least a column named
'dataset' and an additional column with values to use as the basis for the
comparison.}

\item{ds1, ds2}{The names of the two data sets to be compared.}

\item{column}{The name of the column(s) of \code{df} to be used as the basis
for the comparison.}

\item{subsampleSize}{The number of observations for which certain
time-consuming statistics will be calculated. The observations will be
selected randomly among the rows of \code{df}.}

\item{permute}{Whether to permute the dataset column of \code{df} before
calculating the statistics.}

\item{kmin, kfrac}{For statistics that require the extraction of k nearest
neighbors of a given point, the number of neighbors will be max(kmin, kfrac
* nrow(df)).}

\item{xmin, xmax}{Smallest and largest value of \code{column}, used to
normalize the x-axis when calculating the area between the eCDFs.}
}
\value{
A vector with statistics and p-values
}
\description{
Calculate a range of statistics and p-values for comparison of two data sets.
}
\author{
Charlotte Soneson
}
\keyword{internal}
