% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decoupleRnival.R
\name{meta_network_cleanup}
\alias{meta_network_cleanup}
\title{meta_network_cleanup}
\usage{
meta_network_cleanup(meta_network)
}
\arguments{
\item{meta_network}{A data frame with columns 'source', 'interaction', and 'target'.}
}
\value{
A cleaned up meta network data frame.
}
\description{
This function cleans up a meta network data frame by removing self-interactions,
calculating the mean interaction values for duplicated source-target pairs, and
keeping only interactions with values of 1 or -1.
}
\examples{
# Create a meta network data frame
example_meta_network <- data.frame(
source = c("A", "B", "C", "D", "A", "B", "C", "D", "A"),
interaction = c(1, 1, 1, -1, 1, -1, 1, -1, 1),
target = c("B", "C", "D", "A", "C", "D", "A", "B", "B")
)

# Clean up the example meta network
cleaned_meta_network <- meta_network_cleanup(example_meta_network)
print(cleaned_meta_network)

}
