% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consensusSeekeR.R
\docType{data}
\name{PING_nucleosome_ranges}
\alias{PING_nucleosome_ranges}
\title{Ranges associated to nucleosomes detected by the PING software using
syntetic reads generated using a normal distribution.
For demonstration purpose.}
\format{
A \code{GRanges} containing one entry per detected
nucleosome. The ranges are surronding the nucleosomes present in the dataset
\code{PING_nucleosome_positions}. The genomic ranges have been obtained by
adding  73 bps on both sides of the detected positions.
}
\usage{
data(PING_nucleosome_ranges)
}
\description{
Ranges associated to nucleosomes detected by the PING software using
syntetic reads generated using a normal distribution with a variance
of 20 for regions chr1:10000-15000.
}
\examples{

## Loading datasets
data(PING_nucleosome_positions)
data(PING_nucleosome_ranges)
data(NOrMAL_nucleosome_positions)
data(NOrMAL_nucleosome_ranges)
data(NucPosSimulator_nucleosome_positions)
data(NucPosSimulator_nucleosome_ranges)

## Assigning experiment name to each row of the dataset.
## Position and range datasets from the same sofware must
## have identical names.
names(PING_nucleosome_positions) <- rep("PING",
                            length(PING_nucleosome_positions))
names(PING_nucleosome_ranges) <- rep("PING",
                            length(PING_nucleosome_ranges))
names(NOrMAL_nucleosome_positions) <-rep("NOrMAL",
                            length(NOrMAL_nucleosome_positions))
names(NOrMAL_nucleosome_ranges) <- rep("NOrMAL",
                            length(NOrMAL_nucleosome_ranges))
names(NucPosSimulator_nucleosome_positions) <-rep("NucPosSimulator",
                            length(NucPosSimulator_nucleosome_positions))
names(NucPosSimulator_nucleosome_ranges) <- rep("NucPosSimulator",
                            length(NucPosSimulator_nucleosome_ranges))

## Calculating consensus regions for chromosome 1
## with a default region size of 20 bp (2 * extendingSize).
## which is not extended to include all genomic regions for the closest
## peak to the median position of all peaks included in the region (for
## each experiment).
## Nucleosomes from at least 2 software must be present in a region to
## be retained as a consensus region.
chrList <- Seqinfo(c("chr1"), c(249250621), NA)
findConsensusPeakRegions(
    narrowPeaks = c(PING_nucleosome_ranges,
                            NOrMAL_nucleosome_ranges,
                            NucPosSimulator_nucleosome_ranges),
    peaks = c(PING_nucleosome_positions,
                            NOrMAL_nucleosome_positions,
                            NucPosSimulator_nucleosome_positions),
    chrInfo = chrList,
    extendingSize = 10,
    expandToFitPeakRegion = FALSE,
    shrinkToFitPeakRegion = FALSE,
    minNbrExp = 2,
    nbrThreads = 1)

}
\references{
\itemize{
\item Sangsoon W, Zhang X, Sauteraud R, Robert F and Gottardo R. 2013.
PING 2.0: An R/Bioconductor package for nucleosome positioning using
next-generation sequencing data. Bioinformatics 29 (16): 2049-50.
}
}
\seealso{
\itemize{
    \item{\code{\link{PING_nucleosome_positions}} the associate
genomic positions dataset.}
    \item{\code{\link{findConsensusPeakRegions}} for extracting regions
sharing nucleosomes from more than one experiment.}
}
}
\keyword{datasets}
