% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consensusSeekeR.R
\docType{data}
\name{A549_NR3C1_CFQ_NarrowPeaks_partial}
\alias{A549_NR3C1_CFQ_NarrowPeaks_partial}
\title{Ranges with the greatest evidence of transcription factor binding
for the NR3C1 transcription factor from ENCODE (DDC accession: ENCFF002CFQ).
For demonstration purpose.}
\format{
A \code{GRanges} containing one entry per site. The ranges are
surronding the peaks present in the dataset
\code{A549_NR3C1_CFQ_Peaks_partial}.
}
\source{
The Encyclopedia of DNA Elements (ENCODE) (DCC accession:
ENCFF002CFQ)
}
\usage{
data(A549_NR3C1_CFQ_NarrowPeaks_partial)
}
\description{
Ranges representing the greatest evidence of enrichment for
the NR3C1 transcription factor (DCC accession: ENCFF002CFQ)
for regions chr2:40000000-50000000 and chr3:10000000-13000000
from
the Encyclopedia of DNA Elements (ENCODE) data (Dunham I et al. 2012).
}
\details{
The peaks and ranges have been obtained using an optimal IDR analysis
done on all replicates.
}
\examples{

## Loading datasets
data(A549_NR3C1_CFQ_NarrowPeaks_partial)
data(A549_NR3C1_CFQ_Peaks_partial)
data(A549_NR3C1_CFS_NarrowPeaks_partial)
data(A549_NR3C1_CFS_Peaks_partial)

## Assigning experiment name to each row of the dataset.
## NarrowPeak and Peak datasets from the same experiment must
## have identical names.
names(A549_NR3C1_CFQ_NarrowPeaks_partial) <- rep("NR3C1_CFQ",
                            length(A549_NR3C1_CFQ_NarrowPeaks_partial))
names(A549_NR3C1_CFQ_Peaks_partial) <- rep("NR3C1_CFQ",
                            length(A549_NR3C1_CFQ_Peaks_partial))
names(A549_NR3C1_CFS_NarrowPeaks_partial) <-rep("NR3C1_CFS",
                            length(A549_NR3C1_CFS_NarrowPeaks_partial))
names(A549_NR3C1_CFS_Peaks_partial) <- rep("NR3C1_CFS",
                            length(A549_NR3C1_CFS_Peaks_partial))

## Calculating consensus regions for chromosome 3
## with a default region size of 300 bp (2 * extendingSize)
## which is extended to include all genomic regions for the closest
## peak to the median position of all peaks included in the region (for
## each experiment).
## Peaks from both experiments must be present in a region to
## be retained as a consensus region.
chrList <- Seqinfo(c("chr3"), c(198022430), NA)
findConsensusPeakRegions(
    narrowPeaks = c(A549_NR3C1_CFQ_NarrowPeaks_partial,
                            A549_NR3C1_CFS_NarrowPeaks_partial),
    peaks = c(A549_NR3C1_CFQ_Peaks_partial,
                            A549_NR3C1_CFS_Peaks_partial),
    chrInfo = chrList,
    extendingSize = 150,
    expandToFitPeakRegion = FALSE,
    shrinkToFitPeakRegion = TRUE,
    minNbrExp = 2,
    nbrThreads = 1)

}
\references{
\itemize{
\item Dunham I, Kundaje A, Aldred SF, et al. An integrated encyclopedia
of DNA elements in the human genome. Nature. 2012 Sep 6;489(7414):57-74.
}
}
\seealso{
\itemize{
    \item{\code{\link{A549_NR3C1_CFQ_Peaks_partial}} the associate
genomic regions dataset.}
    \item{\code{\link{findConsensusPeakRegions}} for extracting regions
sharing the same features in more than one experiment.}
}
}
\keyword{datasets}
