% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/nLineages.R
\name{nLineages}
\alias{nLineages}
\alias{nLineages,SingleCellExperiment-method}
\alias{nLineages,SlingshotDataSet-method}
\alias{nLineages,PseudotimeOrdering-method}
\title{Number of lineages}
\usage{
nLineages(sds, ...)

\S4method{nLineages}{SingleCellExperiment}(sds)

\S4method{nLineages}{SlingshotDataSet}(sds)

\S4method{nLineages}{PseudotimeOrdering}(sds)
}
\arguments{
\item{sds}{A slingshot object already run on the full dataset. Can be either a
\code{\link[slingshot]{SlingshotDataSet}} or a
\code{\link[SingleCellExperiment]{SingleCellExperiment}} object.}

\item{...}{parameters including:}
}
\value{
The number of lineages in the slingshot object
}
\description{
Return the number of lineages for a slingshot object
}
\examples{
data(list = 'slingshotExample', package = "slingshot")
if (!"cl" \%in\% ls()) {
  rd <- slingshotExample$rd
  cl <- slingshotExample$cl
}
sds <- slingshot::slingshot(rd, cl)
nLineages(sds)
}
