% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_hotspots.R
\name{find_hotspots}
\alias{find_hotspots}
\title{significant hotspot calculator}
\usage{
find_hotspots(data, regions, pvalue, threshold, include_genes, rank)
}
\arguments{
\item{data}{a dataframe containing the chromosome, base pair
position, and optionally gene name of each mutation. Dataframe must contain
columns with the following names:
"Chromosome" <-- Chromosome number where the mutation is located
"Position" <-- Genomic position number where the mutation is located
"Sample" <-- Unique ID for each sample in dataset
"Gene" <-- Name of the gene which mutation is located in (optional)}

\item{regions}{a dataframe containing the chromosome, start and end
base pair position of each region of interest}

\item{pvalue}{the p-value cutoff for included hotspots}

\item{threshold}{the cutoff empirical distribution for Kolmogorov-Smirnov
test}

\item{include_genes}{true or false whether gene names are included in
regions dataframe}

\item{rank}{true or false whether regions dataframe is already ranked and
includes mutation count of total dataset}
}
\value{
A list containing the following:
\enumerate{
\item dataframe containing the genomic regions with significant
mutation frequency
\item plotly object Dotplot showing the percentage of samples with mutations in each ranked
genomic region, highlighting significantly mutated hotspots
\item plotly object ECDF plot showing the difference in mutation frequency between hotspots
and non-hotspots
}
}
\description{
Based on a panel of genomic regions, this function calculates the
regions which are found to have significantly higher mutation
frequency compared to less mutated regions.
}
\details{
This function begins by measuring the mutation frequency for each
unique sample for each provided genomic region. Beginning with the
top ranked hotspot, a Kolmogorov-Smirnov test is preformed on the
mutation frequency of the top genomic region compared to the normalized
mutation frequency of all the lower-ranked regions. This continues,
then running the Kolmogorov-Smirnov test for the normalized mutation
frequency of the top 2 genomic regions compared to the normalized
mutation frequency of all lower-ranked regions.This process repeats itself,
continuously adding an additional genomic regions each time until either
the set p-value or empirical distribution threshold is not met. Once this
cutoff has been reached, an established list of mutation hotspots is
provided.
}
\examples{

data("compSPOT_example_mutations")
data("compSPOT_example_regions")
significant_spots <- find_hotspots(data = compSPOT_example_mutations,
regions = compSPOT_example_regions,
pvalue = 0.05, threshold = 0.2, include_genes = TRUE, rank = TRUE)


}
