% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synteny.R
\name{assess_synnet_list}
\alias{assess_synnet_list}
\title{Assess list of synteny networks as in \code{assess_synnet}}
\usage{
assess_synnet_list(synnet_list = NULL, cc_type = "average")
}
\arguments{
\item{synnet_list}{A list of networks, each network being
an edge list as a 2-column data frame, with columns 1 and 2
representing names of loci in anchor 1 and anchor 2, respectively.}

\item{cc_type}{Type of clustering coefficient to be calculated.
One of 'global' or 'average'. Default: 'average'.}
}
\value{
A data frame with the following variables:
\describe{
\item{CC}{Numeric representing clustering coefficient.}
\item{Node_count}{Numeric representing number of nodes in the network.}
\item{Rsquared}{Numeric indicating the coefficient of determination
for the scale-free topology fit.}
\item{Score}{Numeric representing network score, which is
the product of 'CC' and 'Node_number'.}
\item{Network}{Character of network name.}
}
}
\description{
Assess list of synteny networks as in \code{assess_synnet}
}
\examples{
set.seed(123)
data(synnet)
net1 <- synnet
net2 <- synnet[-sample(1:10000, 500), ]
net3 <- synnet[-sample(1:10000, 1000), ]
synnet_list <- list(net1 = net1, net2 = net2, net3 = net3)
assess_synnet_list(synnet_list)
}
