% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clEnrich.R
\name{clEnrich}
\alias{clEnrich}
\title{Gene set enrichment for clusters}
\source{
Gene sets are from

1. http://www.broadinstitute.org/gsea/msigdb/index.jsp

2. http://amp.pharm.mssm.edu/Enrichr/
}
\usage{
clEnrich(
  genecl_obj,
  annofile = NULL,
  sampleLabel = NULL,
  TermFreq = 0,
  ncore = 1
)
}
\arguments{
\item{genecl_obj}{a genecl object}

\item{annofile}{gene set annotation file}

\item{sampleLabel}{sameple Label. Do make the label of interest located after
the control label in the order of factor. See details.}

\item{TermFreq}{a value from [0,1) to filter low-frequence gene sets}

\item{ncore}{the number of cores used}
}
\value{
a list containing the enrichment score for each clustering methods 
and cluster numbers included in the genecl_obj
}
\description{
Gene set enrichment for clusters sourced from coExp function. the enrichment
score are based on -log2(p) with p from hyper-geometric test.
}
\details{
sampleLable:
Use factor(c("Normal", "Cancer", "Normal"), levels=c("Normal", "Cancer")), 
instead of factor(c("Normal", "Cancer","Normal")). This parameter will affect
the direction of gene regulation in cogena.

Gene sets availiable (See vignette for more): 
\itemize{
\item c2.cp.kegg.v7.01.symbols.gmt.xz (From Msigdb)
\item c2.cp.reactome.v7.01.symbols.gmt.xz (From Msigdb)
\item c5.bp.v7.01.symbols.gmt.xz (From Msigdb)
}
}
\examples{

#annotaion
annoGMT <- "c2.cp.kegg.v7.01.symbols.gmt.xz"
annofile <- system.file("extdata", annoGMT, package="cogena")

utils::data(Psoriasis)
clMethods <- c("hierarchical","kmeans","diana","fanny","som","model","sota","pam","clara","agnes")
genecl_result <- coExp(DEexprs, nClust=2:3, clMethods=c("hierarchical","kmeans"), 
    metric="correlation", method="complete", ncore=2, verbose=TRUE)

clen_res <- clEnrich(genecl_result, annofile=annofile, sampleLabel=sampleLabel)
    
}
