% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getReadCountsFromBAM.R
\name{getReadCountsFromBAM}
\alias{getReadCountsFromBAM}
\title{Calculation of read counts from BAM files.}
\usage{
getReadCountsFromBAM(BAMFiles, sampleNames, refSeqNames, WL = 25000,
  parallel = 0, ...)
}
\arguments{
\item{BAMFiles}{BAMFiles}

\item{sampleNames}{The corresponding sample names to the BAM Files.}

\item{refSeqNames}{Names of the reference sequence that should be analyzed.
The name must appear in the header of the BAM file. If it is not given
the function will select the first reference sequence that appears in the
header of the BAM files. Can be set to analyze multipe chromosomes at once, 
e.g. refSeqNames=c("chr1","chr2")}

\item{WL}{Windowlength. Length of the initial segmentation of the genome in
basepairs. Should be chosen such that on the average 100 reads are contained
in each segment.}

\item{parallel}{The number of parallel processes to be used for this function.
Default=0.}

\item{...}{Additional parameters passed to the function "countBamInGRanges" 
of the Bioconductor package "exomeCopy". Quality filters for read counts can 
be adjusted there.}
}
\value{
An instance of "GRanges", that contains the breakpoints of the 
initial segments and the raw read counts that were extracted from the BAM
files. This object can be used as input for cn.mops and other CNV detection
methods.
}
\description{
Generates the read counts from BAM Files. 
These counts are necessary for CNV detection methods based
on depth of coverage information.

This function can also be run in a parallel version.
}
\examples{
BAMFiles <- list.files(system.file("extdata", package="cn.mops"),pattern=".bam$",full.names=TRUE)
bamDataRanges <- getReadCountsFromBAM(BAMFiles,
					sampleNames=paste("Sample",1:3),WL=5000)
X <- getReadCountsFromBAM(BAMFiles,
					sampleNames=paste("Sample",1:3),WL=5000,parallel=2)
}
\author{
Guenter Klambauer \email{klambauer@bioinf.jku.at}
}
