% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R, R/io.R
\name{parse.gmt}
\alias{parse.gmt}
\alias{parse_gmt}
\title{Read a GMT file and return a list}
\usage{
parse.gmt(...)

parse_gmt(fname)
}
\arguments{
\item{...}{arguments passed on to \code{parse_gmt}}

\item{fname}{the file path to be parsed}
}
\value{
a list of the contents of \code{fname}. See details.
}
\description{
Read a GMT file and return a list
}
\details{
\code{parse_gmt} returns a nested list object. The top
  level contains one list per row in \code{fname}. Each of 
  these is itself a list with the following fields:
  - \code{head}: the name of the data (row in \code{fname})
  - \code{desc}: description of the corresponding data
  - \code{len}: the number of data items
  - \code{entry}: a vector of the data items
}
\examples{
gmt_path <- system.file("extdata", "query_up.gmt", package="cmapR")
gmt <- parse_gmt(gmt_path)
str(gmt)

}
\seealso{
Visit \url{http://clue.io/help} for details on the GMT file format

Other CMap parsing functions: 
\code{\link{lxb2mat}()},
\code{\link{parse.gmx}()},
\code{\link{parse.grp}()},
\code{\link{write_gmt}()},
\code{\link{write_grp}()}
}
\concept{CMap parsing functions}
