% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{query_rank_bias}
\alias{query_rank_bias}
\title{Query rank bias results}
\usage{
query_rank_bias(bias_list, id_mat, id_ref)
}
\arguments{
\item{bias_list}{list of rank diff matrix between cluster and reference cell types}

\item{id_mat}{name of cluster from average cluster matrix}

\item{id_ref}{name of cell type in reference matrix}
}
\value{
data.frame rank diff values
}
\description{
Query rank bias results
}
\examples{
avg <- average_clusters(
    mat = pbmc_matrix_small,
    metadata = pbmc_meta,
    cluster_col = "classified",
    if_log = FALSE
)

rankdiff <- find_rank_bias(
    avg,
    cbmc_ref,
    query_genes = pbmc_vargenes
)

qres <- query_rank_bias(
    rankdiff,
    "CD14+ Mono",
    "CD14+ Mono"
)
}
