% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppi.R
\name{getPPI}
\alias{getPPI}
\title{getPPI}
\usage{
getPPI(
  x,
  ID = 1,
  taxID = "auto",
  required_score = NULL,
  network_type = "functional",
  add_nodes = 0,
  show_query_node_labels = 0,
  output = "igraph"
)
}
\arguments{
\item{x}{an `enrichResult`` object or a vector of proteins, e.g. `c("PTCH1", "TP53", "BRCA1", "BRCA2")`}

\item{ID}{ID or index to extract genes in the enriched term(s) if `x` is an `enrichResult` object}

\item{taxID}{NCBI taxon identifiers (e.g. Human is 9606, see: [STRING organisms](https://string-db.org/cgi/input.pl?input_page_active_form=organisms).}

\item{required_score}{threshold of significance to include a interaction, a number between 0 and 1000 (default depends on the network)}

\item{network_type}{network type: functional (default), physical}

\item{add_nodes}{adds a number of proteins with to the network based on their confidence score (default:1)}

\item{show_query_node_labels}{when available use submitted names in the preferredName column when (0 or 1) (default:0)}

\item{output}{one of `data.frame` or `igraph`}
}
\value{
a `data.frame` or an `igraph` object
}
\description{
getPPI
}
\details{
[Getting the STRING network interactions](https://string-db.org/cgi/help.pl?sessionId=btsvnCeNrBk7).
}
\author{
Yonghe Xia and modified by Guangchuang Yu
}
