% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFeatureBoxplot.R
\name{plotFeatureBoxplot}
\alias{plotFeatureBoxplot}
\alias{plotFeatureBoxplot,ClusterExperiment,character-method}
\alias{plotFeatureBoxplot,ClusterExperiment,numeric-method}
\title{Plot boxplot of feature values by cluster}
\usage{
\S4method{plotFeatureBoxplot}{ClusterExperiment,character}(object, feature, whichCluster = "primary", ...)

\S4method{plotFeatureBoxplot}{ClusterExperiment,numeric}(
  object,
  feature,
  whichCluster = "primary",
  plotUnassigned = FALSE,
  unassignedColor = NULL,
  missingColor = NULL,
  main = NULL,
  whichAssay = 1,
  ...
)
}
\arguments{
\item{object}{a ClusterExperiment object}

\item{feature}{identification of feature to plot, either row name or index}

\item{whichCluster}{argument that can be a single numeric or character value
indicating the \emph{single} clustering to be used. Giving values that result in more than one clustering will result in an error. See details of \code{\link{getClusterIndex}}.}

\item{...}{arguments passed to \code{\link{boxplot}}}

\item{plotUnassigned}{whether to plot the unassigned samples as a cluster
(either -1 or -2)}

\item{unassignedColor}{If not NULL, should be character value giving the
color for unassigned (-2) samples (overrides \code{clusterLegend}) default.}

\item{missingColor}{If not NULL, should be character value giving the color
for missing (-2) samples (overrides \code{clusterLegend}) default.}

\item{main}{title of plot. If NULL, given default title.}

\item{whichAssay}{numeric or character specifying which assay to use. See
\code{\link[SummarizedExperiment]{assay}} for details.}
}
\value{
A plot is created. The output of boxplot is returned (see
\code{\link{boxplot}}), with additional elements \code{colors} and 
 \code{clusterIds} that gives the colors and internal ids that match 
 each boxplot (pulled from \code{clusterLegend} but in the order of plot)
}
\description{
Plot a boxplot of the (transformed) values for a particular
  gene, separated by cluster
}
\examples{
data(simData)
#Create a ClusterExperiment object
cl <- clusterMany(simData, nReducedDims=c(5, 10, 50), reducedDim="PCA",
   clusterFunction="pam", ks=2:4, findBestK=c(TRUE,FALSE),
   removeSil=c(TRUE,FALSE), makeMissingDiss=TRUE)
#give names to the clusters
cl<-renameClusters(cl, whichCluster=1, 
   value=letters[1:nClusters(cl)[1]])
plotFeatureBoxplot(cl,feature=1)
}
\seealso{
\code{\link{boxplot}}
}
