% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllHelperDendro.R
\name{clusterDendrogram}
\alias{clusterDendrogram}
\alias{clusterDendrogram,ClusterExperiment-method}
\alias{sampleDendrogram,ClusterExperiment-method}
\alias{sampleDendrogram}
\alias{nInternalNodes,ClusterExperiment-method}
\alias{nInternalNodes}
\alias{nTips,ClusterExperiment-method}
\alias{nTips}
\alias{nNodes,ClusterExperiment-method}
\alias{nNodes}
\alias{nodeLabels<-,ClusterExperiment-method}
\alias{nodeLabels<-}
\alias{checkDendrogram,ClusterExperiment,phylo4d,phylo4d-method}
\alias{checkDendrogram}
\alias{nodeLabels,ClusterExperiment-method}
\alias{nodeLabels}
\alias{nodeIds,ClusterExperiment-method}
\alias{nodeIds}
\alias{convertToDendrogram,ClusterExperiment-method}
\alias{convertToDendrogram}
\title{Accessing and manipulating the dendrograms}
\usage{
\S4method{clusterDendrogram}{ClusterExperiment}(x)

\S4method{sampleDendrogram}{ClusterExperiment}(x)

\S4method{nInternalNodes}{ClusterExperiment}(x)

\S4method{nTips}{ClusterExperiment}(x)

\S4method{nNodes}{ClusterExperiment}(x)

\S4method{nodeLabels}{ClusterExperiment}(x, ...) <- value

\S4method{checkDendrogram}{ClusterExperiment,phylo4d,phylo4d}(x, dendroCluster, dendroSample, whichCluster = "dendro")

\S4method{nodeLabels}{ClusterExperiment}(x)

\S4method{nodeIds}{ClusterExperiment}(x, type = c("all", "internal", "tip"))

\S4method{convertToDendrogram}{ClusterExperiment}(x)
}
\arguments{
\item{x}{a ClusterExperiment object}

\item{...}{additional options passed to \code{nodeLabels<-} (ignored)}

\item{value}{replacement value for \code{nodeLabels}. See details.}

\item{dendroCluster}{a \code{phylo4d} to be check as for being cluster hierarchy}

\item{dendroSample}{a \code{phylo4d} to be check as for being cluster hierarchy}

\item{whichCluster}{argument that can be a single numeric or character value
indicating the \emph{single} clustering to be used. Giving values that result in more than one clustering will result in an error. See details of \code{\link{getClusterIndex}}.}

\item{type}{the type of node to return results from. One of "all",
"internal", and "tip".}
}
\value{
\code{clusterDendrogram} returns the dendrogram describing the
  clustering hierarchy.

\code{sampleDendrogram} returns the dendrogram that expands the
  cluster hierarchy to the samples.

\code{nInternalNodes} returns the number of \emph{internal} nodes of
  the cluster hierarchy.

\code{nTips} returns the number of tips of the cluster hierarchy
  (same as number of non-negative clusters in the dendrogram clustering)

\code{nNodes} returns the number of total nodes of the cluster hierarchy

\code{nodeLabels<-} sets the node labels of the \emph{cluster}
dendrogram

\code{checkClusterDendrogram} checks if a \code{phylo4d} objects are
  valid for the cluster and sample dendrogram slots of the given
  \code{ClusterExperiment} object. Returns \code{TRUE} if there are no
  problems. Otherwise creates error.

\code{nodeLabels} returns the node labels of the \emph{cluster}
dendrogram

\code{nodeIds} returns the internal (permanent) node ids of the
  \emph{cluster} dendrogram

\code{convertToDendrogram} returns the sample dendrogram converted to
  a \code{\link[stats]{dendrogram}} class.
}
\description{
These functions are for accessing and manipulating the
  dendrograms stored in a \code{ClusterExperiment} object. We also document
  the required format of these dendrograms here.
}
\details{
Two dendrograms are stored in a \code{ClusterExperiment} object. One
  is a dendrogram that describes the hierarchy between the clusters
  (\code{@dendro_clusters}), and the other is a dendrogram that extends that
  hierarchy to include the clusters (\code{@dendro_samples}). The clustering
  that is used to make these hierarchies is saved in as well
  (\code{@dendro_index})

The dendrograms stored in a \code{ClusterExperiment} object are
  required to be a \code{\link[phylobase]{phylo4d-class}} from the package
  \code{phylobase} (which uses the basic format of the S3 class
  \code{\link[ape]{phylo}} in the \code{ape} package to store the edges;
  \code{phylobase} makes it a S4 class with some useful helpers). This class
  allows storage of a data.frame of information corresponding to information
  on each node (see \code{\link[phylobase]{tdata}}).

Additional requirements are made of these dendrograms to be a valid
  for the slots of the \code{ClusterExperiment} class, described below,
  regarding the data that must be stored with it and the labels which can be
  assigned. Possible dendrograms can be checked for validity with the
  function \code{checkDendrogram}. The reason for the restrictions on the
  labels is so as to not duplicate storage of the names, see below
  descriptions for where to save user-defined names.

\itemize{ 
\item{Labels}{The cluster dendrogram can only have labels
  on the \emph{internal} nodes. Labels on the internal nodes of the cluster
  dendrogram can be set by the user (the function \code{nodeLabels<-} is
  defined to work on a \code{ClusterExperiment} object to make this easy).
  The tips of the cluster dendrogram, corresponding to the clusters, cannot
  have labels; users can set the labels (e.g. for plotting, etc) in the
  \code{\link{clusterLegend}} slot using the function
  \code{\link{renameClusters}}.} 
\item{Data}{ The cluster hierarchy must have
  data stored with it that has the following columns (additional ones are
  allowed):
  \itemize{ 
  \item{NodeId}{The permanent node id for the node. Must
  be of the format "NodeIdX" where "X" is a integer.} 
  \item{Position}{The
  type of node, in terms of its position. The internal nodes should have the
  values "cluster hierarchy node" while the tips should have "cluster
  hierarchy tip".} 
  \item{ClusterIdDendro}{Only for tips of dendrogram, should
  have the id that corresponds to its cluster in the clustering of the
  @dendro_index. Of the form "ClusterIdX", where "X" is the internal cluster
  id (see \code{\link{clusterLegend}}). Internal nodes should have NA
  values.} 
  \item{ClusterIdMerge}{The id that corresponds to the cluster in
  the clustering of the @merge_index, if it exists. Of the form "ClusterIdX",
  where "X" is the internal cluster id (see \code{\link{clusterLegend}}} } }
  }

\itemize{
\item{Labels}{The sample dendrogram is not allowed to have ANY labels. The
names for those nodes that correspond to the cluster hierarchy will be pulled
from the names in the cluster hierarchy for plotting, etc. and should be set
there (see above). Sample names for the tips of the tree will be pulled from
\code{colnames} of the object and should be set there. }
\item{Data}{ 
The cluster hierarchy must have data stored with it that has the following
columns (additional ones are allowed):
 \itemize{
  \item{NodeId}{For those nodes that correspond to a node in the cluster
  hierarchy, should have its permanent node id in this column. Other nodes
  should be NA.}
  \item{Position}{The type of node, in terms of its position. The internal
  nodes should have the values "cluster hierarchy node" while the tips should
  have "cluster hierarchy tip".}
  \item{SampleIndex}{Only for tips of dendrogram, the index of the sample at
  that tip to the samples in the object.}
 }
} 
}

For setting the node labels of the cluster dendrogram via 
\code{nodeLabels<-}, the replacement value has to have names that match the 
internal ids of the cluster dendrogram (the \code{NodeId} column).
}
\section{The Stored Dendrograms}{
NA
}

\section{Cluster Hierarchy}{
NA
}

\section{Sample Hierarchy}{
NA
}

\section{Helper Functions}{
NA
}

\examples{
data(rsecFluidigm)
# retrieve the dendrogram of the clusters:
head(clusterDendrogram(rsecFluidigm),5)
# retrieve the dendrogram of the samples:
head(sampleDendrogram(rsecFluidigm),5)
# Return # internal nodes from cluster hierarchy
nInternalNodes(rsecFluidigm)
# Return # tips from cluster hierarchy (i.e. # clusters)
nTips(rsecFluidigm)
# Return internal node ids
nodeIds(rsecFluidigm,type="internal")
# Labels assigned to internal nodes
nodeLabels(rsecFluidigm)
# Assign new labels to the internal nodes of the cluster hierarchy
l1<-paste("A", 1:nInternalNodes(rsecFluidigm),sep=":")
names(l1)<-nodeIds(rsecFluidigm,type="internal")
nodeLabels(rsecFluidigm)<-l1
nodeLabels(rsecFluidigm)
}
\seealso{
\code{\link{makeDendrogram}},
  \code{\link[phylobase]{phylo4d-class}}, \code{\link[ape]{phylo}}

\code{\link[stats]{dendrogram}}
}
