% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-spliceSiteProfile.R
\name{spliceSiteProfile}
\alias{spliceSiteProfile}
\title{spliceSiteProfile for the GRanges objects}
\usage{
spliceSiteProfile(
    object,
    annotation,
    title = "Splice Site Profile",
    exlevel = NA,
    extranscript_support_level = NA,
    exon_length_filtering = TRUE,
    intron_length_filtering = TRUE,
    flanking = 150,
    bin = 30
)
}
\arguments{
\item{object}{A GRanges object which should contains all the peaks that you
want to check}

\item{annotation}{A path way to the annotation file. The format of the
annotation file should be gff3 and downloaded from
https://www.gencodegenes.org/}

\item{title}{The main title for the output meta gene profile plot.}

\item{exlevel}{A parameter for the annotation filtering. exlevel represents
the level that you would like to exclude. NA means no level filtering
for the annotation file. The level from the annotations refers to
how reliable this annotation is. For more information about level
please check
https://www.gencodegenes.org/pages/data_format.html.}

\item{extranscript_support_level}{A parameter for the annotation filtering.
extranscript_support_level represents the transcript_support_level
that you would like to exclude (e.g. 4 and 5). NA means no
transcript_support_level filtering for the annotation file.
Transcripts are scored according to how well mRNA and EST alignments
match over its full length. Here the number 6 means the
transcript_support_level NA. For more information about level please
check
https://www.gencodegenes.org/pages/data_format.html.}

\item{exon_length_filtering}{The exon_length_filtering should be a logical
value which indicated whether user would like to exclude the exons
that have a length less than flanking value. Set this parameter to TRUE
to turn on this filtering step.}

\item{intron_length_filtering}{The intron_length_filtering should be a
logical value which indicated whether user would like to exclude the
introns that have a length less than flanking value. Set this parameter
to TRUE to turn on this filtering step.}

\item{flanking}{The size of the flanking windows that you would like to
check. Flanking=5 will give you the result of the 10+1nt
windows around the center of peaks.}

\item{bin}{A number that indicates how many bins would you like to use in
the histogram.}
}
\value{
A list object, the list 1 contains the information of the
        position of peaks around 5' or 3' splice sites. The list 2
        includes the plot of spliceSiteProfile
}
\description{
An function to check the enrichment of peaks around the splice
    sites in a absolute distance.
}
\examples{
## Load the test data and get the path to the test gff3 file
testpath <- system.file("extdata", package = "cliProfiler")
test <- readRDS(file.path(testpath, "test.rds"))
test_gff3 <- file.path(testpath, "annotation_test.gff3")

output <- spliceSiteProfile(test, test_gff3,
    flanking = 200, bin = 40
)
}
\author{
You Zhou, Kathi Zarnack
}
