% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{mergedBSJunctions}
\alias{mergedBSJunctions}
\title{mergedBSJunctions}
\format{
A data frame with 41558 rows and 16 columns
\describe{
    \item{id}{Unique identifier}
    \item{gene}{is the gene name whose exon coordinates overlap that of
    the given back-spliced junctions}
    \item{strand}{is the strand where the gene is transcribed}
    \item{chrom}{the chromosome from which the circRNA is derived}
    \item{startUpBSE}{ is the 5' coordinate of the upstream back-spliced
    exon in the transcript. This corresponds to the back-spliced junction /
    acceptor site}
    \item{endDownBSE}{is the 3' coordinate of the downstream back-spliced
    exon in the transcript. This corresponds to the back-spliced junction /
    donor site}
    \item{tool}{ are the tools that identified the back-spliced
     junctions}
    \item{C1}{Number of occurences of each circRNA in control 1}
    \item{C2}{Number of occurences of each circRNA in control 2}
    \item{C3}{Number of occurences of each circRNA in control 3}
    \item{D1}{Number of occurences of each circRNA in DCM 1}
    \item{D2}{Number of occurences of each circRNA in DCM 2}
    \item{D3}{Number of occurences of each circRNA in DCM 3}
    \item{H1}{Number of occurences of each circRNA in HCM 1}
    \item{H2}{Number of occurences of each circRNA in HCM 2}
    \item{H3}{Number of occurences of each circRNA in HCM 3}
}
}
\usage{
data(mergedBSJunctions)
}
\description{
A data frame containing genomic coordinates (genome assembly hg19) detected
in human LV tissues of controls and diseased hearts. This data frame was
generated with \code{\link{mergedBSJunctions}} which grouped circRNAs
commonly identified by the three tools (CircMarker(cm), MapSplice2 (m) and
NCLscan (n)) used for circRNAs detection.
}
\examples{
data(mergedBSJunctions)

}
\keyword{datasets}
