% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importFilesPredictionTool.R
\name{importUroborus}
\alias{importUroborus}
\title{Import circRNAs detected by UROBORUS}
\usage{
importUroborus(pathToFile)
}
\arguments{
\item{pathToFile}{A character string specifying the path to the file
containing the detected circRNAs.}
}
\value{
A data frame.
}
\description{
The function importUroborus is specifically designed to reaad
and adapt the UROBORUS v2.0.0 output file (circRNA_list.txt).
See \url{https://github.com/WGLab/UROBORUS} for more details.
}
\examples{
# Path to an example file containing circRNA detected by UROBORUS
pathToFile <- system.file("extdata", "uroborus/circRNAs_001.txt",
    package="circRNAprofiler")

# Inner function.
# Import circRNAs.
importUroborus(pathToFile)

}
\keyword{internal}
