% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMirSites.R
\name{getMiRsites}
\alias{getMiRsites}
\title{Screen target sequences for miR binding sites}
\usage{
getMiRsites(
  targets,
  miRspeciesCode = "hsa",
  miRBaseLatestRelease = TRUE,
  totalMatches = 7,
  maxNonCanonicalMatches = 1,
  pathToMiRs = NULL
)
}
\arguments{
\item{targets}{A list containing the target sequences to analyze.
This data frame can be generated with \code{\link{getCircSeqs}}.}

\item{miRspeciesCode}{A string specifying the species code (3 letters) as
reported in miRBase db. E.g. to analyze the mouse microRNAs specify "mmu",
to analyze the human microRNAs specify "hsa". Type data(miRspeciesCode)
to see the available codes and the corresponding species reported
in miRBase 22 release. Default value is "hsa".}

\item{miRBaseLatestRelease}{A logical specifying whether to download the
latest release of the mature sequences of the microRNAs from miRBase
(\url{http://www.mirbase.org/ftp.shtml}). If TRUE is specified then the
latest release is automatically downloaded. If FALSE is specified then a
file named mature.fa containing fasta format sequences of all mature miRNA
sequences previously downloaded by the user from mirBase must be present
in the working directory. Default value is TRUE.}

\item{totalMatches}{An integer specifying the total number of matches that
have to be found between the seed region of the miR and the seed site of the
target sequence. If the total number of matches found is less than the
cut-off, the seed site is discarded. The maximun number of possible matches
is 7. Default value is 7.}

\item{maxNonCanonicalMatches}{An integer specifying the max number of
non-canonical matches (G:U) allowed between the seed region of the miR and
the seed site of the target sequence. If the max non-canonical matches found
is greater than the cut-off, the seed site is discarded. Default value is 1.}

\item{pathToMiRs}{A string containing the path to the miRs.txt file.
The file miRs.txt contains the microRNA ids from miRBase
specified by the user. It must have one column with header id. The first row
must contain the miR name starting with the ">", e.g >hsa-miR-1-3p. The
sequences of the miRs will be automatically retrieved from the mirBase latest
release or from the given mature.fa file, that should be present in the
working directory. By default pathToMiRs is set to NULL and the file it is
searched in the working directory. If miRs.txt is located in a different
directory then the path needs to be specified. If this file is absent or
empty, all miRs of the specified species are considered in the
miRNA analysis.}
}
\value{
A list.
}
\description{
The function getMirSites() searches miRNA binding sites within
the circRNA sequences. The user can restrict the analisis only to a subset
of miRs. In this case, miR ids must go in miR.txt file. If the latter
is absent or empty, all miRs of the specified miRspeciesCode are considered
in the analysis.
}
\examples{
# Load a data frame containing detected back-spliced junctions
data("mergedBSJunctions")

# Load short version of the gencode v19 annotation file
data("gtf")

# Annotate the first back-spliced junctions
annotatedBSJs <- annotateBSJs(mergedBSJunctions[1, ], gtf)

# Get genome
if (requireNamespace("BSgenome.Hsapiens.UCSC.hg19", quietly = TRUE)){
genome <- BSgenome::getBSgenome("BSgenome.Hsapiens.UCSC.hg19")

# Retrieve target sequences.
targets <- getCircSeqs(
    annotatedBSJs,
    gtf,
    genome)

# Screen target sequence for miR binding sites.
pathToMiRs <- system.file("extdata", "miRs.txt", package="circRNAprofiler")

#miRsites <- getMiRsites(
#   targets,
#   miRspeciesCode = "hsa",
#   miRBaseLatestRelease = TRUE,
#   totalMatches = 6,
#   maxNonCanonicalMatches = 1,
#   pathToMiRs )
}


}
