% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_deviations.R
\name{computeDeviations}
\alias{computeDeviations}
\alias{computeDeviations,SummarizedExperiment,SummarizedExperiment-method}
\alias{computeDeviations,SummarizedExperiment,MatrixOrmatrix-method}
\alias{computeDeviations,SummarizedExperiment,list-method}
\alias{computeDeviations,SummarizedExperiment,missingOrNULL-method}
\alias{computeDeviations,MatrixOrmatrix,SummarizedExperiment-method}
\alias{computeDeviations,MatrixOrmatrix,MatrixOrmatrix-method}
\alias{computeDeviations,MatrixOrmatrix,list-method}
\alias{computeDeviations,MatrixOrmatrix,missingOrNULL-method}
\title{computeDeviations}
\usage{
computeDeviations(object, annotations, ...)

\S4method{computeDeviations}{SummarizedExperiment,SummarizedExperiment}(
  object,
  annotations,
  background_peaks = getBackgroundPeaks(object),
  expectation = computeExpectations(object)
)

\S4method{computeDeviations}{SummarizedExperiment,MatrixOrmatrix}(
  object,
  annotations,
  background_peaks = getBackgroundPeaks(object),
  expectation = computeExpectations(object)
)

\S4method{computeDeviations}{SummarizedExperiment,list}(
  object,
  annotations,
  background_peaks = getBackgroundPeaks(object),
  expectation = computeExpectations(object)
)

\S4method{computeDeviations}{SummarizedExperiment,missingOrNULL}(
  object,
  annotations,
  background_peaks = getBackgroundPeaks(object),
  expectation = computeExpectations(object)
)

\S4method{computeDeviations}{MatrixOrmatrix,SummarizedExperiment}(
  object,
  annotations,
  background_peaks,
  expectation = computeExpectations(object)
)

\S4method{computeDeviations}{MatrixOrmatrix,MatrixOrmatrix}(
  object,
  annotations,
  background_peaks,
  expectation = computeExpectations(object)
)

\S4method{computeDeviations}{MatrixOrmatrix,list}(
  object,
  annotations,
  background_peaks,
  expectation = computeExpectations(object)
)

\S4method{computeDeviations}{MatrixOrmatrix,missingOrNULL}(
  object,
  annotations,
  background_peaks,
  expectation = computeExpectations(object)
)
}
\arguments{
\item{object}{chromVARCounts object}

\item{annotations}{chromVARAnnotations object}

\item{...}{additional arguments}

\item{background_peaks}{(optional) background peaks matrix computed using
\code{\link{getBackgroundPeaks}}, computed internally with default
paramaters if not provided}

\item{expectation}{(optional) expectations computed using
\code{\link{computeExpectations}}, computed automatically if not provided}
}
\value{
\code{\link{chromVARDeviations-class}}, which inherits from
SummarizedExperiment, and has two assays: deviations and deviation scores.
}
\description{
Computes deviations in chromatin accessibility across sets of annotations
}
\details{
multiprocessing using \code{\link[BiocParallel]{bplapply}}
}
\section{Methods (by class)}{
\itemize{
\item \code{computeDeviations(
  object = SummarizedExperiment,
  annotations = SummarizedExperiment
)}: object and annotations are SummarizedExperiment

\item \code{computeDeviations(object = SummarizedExperiment, annotations = MatrixOrmatrix)}: object is SummarizedExperiment,
annotations are Matrix

\item \code{computeDeviations(object = SummarizedExperiment, annotations = list)}: object is SummarizedExperiment,
annotations are list

\item \code{computeDeviations(object = SummarizedExperiment, annotations = missingOrNULL)}: object is SummarizedExperiment,
annotations are missing

\item \code{computeDeviations(object = MatrixOrmatrix, annotations = SummarizedExperiment)}: object and annotations are SummarizedExperiment

\item \code{computeDeviations(object = MatrixOrmatrix, annotations = MatrixOrmatrix)}: object is SummarizedExperiment,
annotations are Matrix

\item \code{computeDeviations(object = MatrixOrmatrix, annotations = list)}: object is SummarizedExperiment,
annotations are list

\item \code{computeDeviations(object = MatrixOrmatrix, annotations = missingOrNULL)}: object is SummarizedExperiment,
annotations are missing

}}
\examples{
# Register BiocParallel
BiocParallel::register(BiocParallel::SerialParam())
# Load very small example counts (already filtered)
data(mini_counts, package = "chromVAR")
# load annotation matrix; result from matchMotifs
data(mini_ix, package = "chromVAR")

# computing deviations
dev <- computeDeviations(object = mini_counts,
                         annotations = mini_ix)
}
\seealso{
\code{\link{computeVariability}}, \code{\link{plotVariability}}
}
\author{
Alicia Schep
}
