% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{write_fusion_reference}
\alias{write_fusion_reference}
\title{Write fusion junction sequence to a fasta file}
\usage{
write_fusion_reference(fusion, filename)
}
\arguments{
\item{fusion}{The Fusion object we want to create a fasta file from.}

\item{filename}{The filename to write to.}
}
\value{
Writes the fusion junction sequence to the given filename.
}
\description{
This function will write the fusion sequence to a fasta file, using
Biostring::writeXStringSet() .
}
\examples{
# Import the filtered defuse results
defuse833keFiltered <- system.file(
  "extdata",
  "defuse_833ke_results.filtered.tsv",
  package="chimeraviz")
fusions <- import_defuse(defuse833keFiltered, "hg19", 1)
# Get a specific fusion
fusion <- get_fusion_by_id(fusions, 5267)
# Create temporary file to hold the fusion sequence
fastaFileOut <- tempfile(pattern = "fusionSequence", tmpdir = tempdir())
# Write fusion sequence to file
write_fusion_reference(fusion, fastaFileOut)

}
