% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fusion_transcripts_graph.R
\name{plot_fusion_transcripts_graph}
\alias{plot_fusion_transcripts_graph}
\title{Graph plot of possible fusion transcripts.}
\usage{
plot_fusion_transcripts_graph(
  fusion,
  edb = NULL,
  which_transcripts = "exonBoundary",
  rankdir = "TB"
)
}
\arguments{
\item{fusion}{The Fusion object to plot.}

\item{edb}{The edb object that will be used to fetch data.}

\item{which_transcripts}{This character vector decides which transcripts are
to be plotted. Can be "exonBoundary", "withinExon", "withinIntron",
"intergenic", or a character vector with specific transcript ids. Default
value is "exonBoundary".}

\item{rankdir}{Choose whether the graph should be plotted from left to right
("LR"), or from top to bottom ("TB"). This parameter is given to
Rgraphviz::plot().}
}
\value{
Creates a fusion transcripts graph plot.
}
\description{
This function takes a fusion object and a TranscriptDb object and plots a
graph showing the possible fusion transcripts.
}
\examples{
# Load data and example fusion event
defuse833ke <- system.file(
  "extdata",
  "defuse_833ke_results.filtered.tsv",
  package="chimeraviz")
fusions <- import_defuse(defuse833ke, "hg19", 1)
fusion <- get_fusion_by_id(fusions, 5267)
# Load edb
edbSqliteFile <- system.file(
  "extdata",
  "Homo_sapiens.GRCh37.74.sqlite",
  package="chimeraviz")
edb <- ensembldb::EnsDb(edbSqliteFile)
# Temporary file to store the plot
pngFilename <- tempfile(
  pattern = "fusionPlot",
  fileext = ".png",
  tmpdir = tempdir())
# Open device
png(pngFilename, width = 500, height = 500)
# Plot!
plot_fusion_transcripts_graph(
  fusion = fusion,
  edb = edb)
# Close device
dev.off()

}
