% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fusion_transcript_with_protein_domain.R
\name{plot_fusion_transcript_with_protein_domain}
\alias{plot_fusion_transcript_with_protein_domain}
\title{Plot a specific fusion transcript with protein domain annotations}
\usage{
plot_fusion_transcript_with_protein_domain(
  fusion,
  edb = NULL,
  bamfile = NULL,
  bedfile = NULL,
  gene_upstream_transcript = "",
  gene_downstream_transcript = "",
  plot_downstream_protein_domains_if_fusion_is_out_of_frame = FALSE
)
}
\arguments{
\item{fusion}{The Fusion object to plot.}

\item{edb}{The edb object that will be used to fetch data.}

\item{bamfile}{The bamfile with RNA-seq data.}

\item{bedfile}{The bedfile with protein domain data.}

\item{gene_upstream_transcript}{The transcript id for the upstream gene.}

\item{gene_downstream_transcript}{The transcript id for the downstream gene.}

\item{plot_downstream_protein_domains_if_fusion_is_out_of_frame}{Setting this to true
makes the function plot protein domains in the downstream gene even though
the fusion is out of frame.}
}
\value{
Creates a fusion transcript plot with annotations of protein domains.
}
\description{
This function takes a fusion object, an ensembldb object, a bedfile with
protein domain data and two specific transcript ids. The function plots the
specific fusion transcript along with annotations of protein domains. If a
bamfile is specified, the fusion transcript will be plotted with coverage
information.
}
\details{
Note that the transcript database used (the edb object) must have the same
seqnames as any bamfile used. Otherwise the coverage data will be wrong.
}
\examples{
# Load data and example fusion event
defuse833ke <- system.file(
  "extdata",
  "defuse_833ke_results.filtered.tsv",
  package="chimeraviz")
fusions <- import_defuse(defuse833ke, "hg19", 1)
fusion <- get_fusion_by_id(fusions, 5267)
# Select transcripts
gene_upstream_transcript <- "ENST00000434290"
gene_downstream_transcript <- "ENST00000370031"
# Load edb
edbSqliteFile <- system.file(
  "extdata",
  "Homo_sapiens.GRCh37.74.sqlite",
  package="chimeraviz")
edb <- ensembldb::EnsDb(edbSqliteFile)
# bamfile with reads in the regions of this fusion event
bamfile5267 <- system.file(
  "extdata",
  "fusion5267and11759reads.bam",
  package="chimeraviz")
# bedfile with protein domains for the transcripts in this example
bedfile <- system.file(
  "extdata",
  "protein_domains_5267.bed",
  package="chimeraviz")
# Temporary file to store the plot
pngFilename <- tempfile(
  pattern = "fusionPlot",
  fileext = ".png",
  tmpdir = tempdir())
# Open device
png(pngFilename, width = 500, height = 500)
# Plot!
plot_fusion_transcript_with_protein_domain(
  fusion = fusion,
  edb = edb,
  bamfile = bamfile5267,
  bedfile = bedfile,
  gene_upstream_transcript = gene_upstream_transcript,
  gene_downstream_transcript = gene_downstream_transcript,
  plot_downstream_protein_domains_if_fusion_is_out_of_frame = TRUE)
# Close device
dev.off()

}
