% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\name{partner_gene_junction_sequence}
\alias{partner_gene_junction_sequence}
\alias{partner_gene_junction_sequence,PartnerGene-method}
\title{Get the junction sequence from a PartnerGene object}
\usage{
partner_gene_junction_sequence(x)

\S4method{partner_gene_junction_sequence}{PartnerGene}(x)
}
\arguments{
\item{x}{The PartnerGene object you wish to retrieve the junction sequence
for.}
}
\value{
The upstream fusion partner gene junction sequence.
}
\description{
This getter retrieves the junction sequence from a PartnerGene object
}
\examples{
# Load data
defuseData <- system.file(
  "extdata",
  "defuse_833ke_results.filtered.tsv",
  package="chimeraviz")
fusions <- import_defuse(defuseData, "hg19", 1)
fusion <- fusions[[1]]
# Get the junction sequence from the upstream fusion partner gene
partner_gene_junction_sequence(upstream_partner_gene(fusion))

}
