% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_oncofuse.R
\name{import_oncofuse}
\alias{import_oncofuse}
\title{Import results from a oncofuse run into a list of Fusion objects.}
\usage{
import_oncofuse(filename, genome_version, limit)
}
\arguments{
\item{filename}{Filename for the oncofuse results .tsv file.}

\item{genome_version}{Which genome was used in mapping (hg19, hg38, etc.).}

\item{limit}{A limit on how many lines to read.}
}
\value{
A list of Fusion objects.
}
\description{
A function that imports the results from a oncofuse run, typically from a
results.filtered.tsv file, into a list of Fusion objects.
}
\details{
This import function was contributed by Lavinia G, ref
https://github.com/stianlagstad/chimeraviz/issues/47#issuecomment-409773158
}
\examples{
oncofuse833ke <- system.file(
  "extdata",
  "oncofuse.outfile",
  package="chimeraviz")
fusions <- import_oncofuse(oncofuse833ke, "hg19", 3)
# This should import a list of 3 fusions described in Fusion objects.

}
