% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\name{fusion_split_reads_count}
\alias{fusion_split_reads_count}
\alias{fusion_split_reads_count,Fusion-method}
\title{Get the split reads count from a Fusion object}
\usage{
fusion_split_reads_count(x)

\S4method{fusion_split_reads_count}{Fusion}(x)
}
\arguments{
\item{x}{The Fusion object you wish to retrieve the split reads count for.}
}
\value{
The Fusion split reads count.
}
\description{
This getter retrieves the split reads count from a Fusion object
}
\examples{
# Load data
defuseData <- system.file(
  "extdata",
  "defuse_833ke_results.filtered.tsv",
  package="chimeraviz")
fusions <- import_defuse(defuseData, "hg19", 1)
fusion <- fusions[[1]]
# Get the split reads count
fusion_split_reads_count(fusion)

}
