% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\name{downstream_partner_gene}
\alias{downstream_partner_gene}
\alias{downstream_partner_gene,Fusion-method}
\alias{downstream_partner_gene<-}
\alias{downstream_partner_gene<-,Fusion-method}
\title{Get the downstream fusion partner gene}
\usage{
downstream_partner_gene(x)

\S4method{downstream_partner_gene}{Fusion}(x)

downstream_partner_gene(object) <- value

\S4method{downstream_partner_gene}{Fusion}(object) <- value
}
\arguments{
\item{x}{The Fusion object you wish to retrieve the downstream PartnerGene
object for.}

\item{object}{The Fusion object you wish to set a new downstream
PartnerGene object for.}

\item{value}{The new PartnerGene object.}
}
\value{
The downstream PartnerGene object.
}
\description{
This getter retrieves the downstream PartnerGene object.

This sets the downstream PartnerGene object of a Fusion object
}
\examples{
# Load data
defuseData <- system.file(
  "extdata",
  "defuse_833ke_results.filtered.tsv",
  package="chimeraviz")
fusions <- import_defuse(defuseData, "hg19", 1)
fusion <- fusions[[1]]
# Get the downstream fusion partner gene
downstream_partner_gene(fusion)

# Load data
defuseData <- system.file(
  "extdata",
  "defuse_833ke_results.filtered.tsv",
  package="chimeraviz")
fusions <- import_defuse(defuseData, "hg19", 1)
fusion <- fusions[[1]]
# Set the downstream PartnerGene object to be the same as the upstream
# PartnerGene object
downstream_partner_gene(fusion) <- upstream_partner_gene(fusion)

}
