% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DelayedSubassign.R
\name{saveDelayedObject,DelayedSubassign-method}
\alias{saveDelayedObject,DelayedSubassign-method}
\title{Saving a DelayedSubassign}
\usage{
\S4method{saveDelayedObject}{DelayedSubassign}(x, file, name)
}
\arguments{
\item{x}{A \linkS4class{DelayedSubassign} object.}

\item{file}{String containing the path to a HDF5 file.}

\item{name}{String containing the name of the group to save into.}
}
\value{
A \code{NULL}, invisibly.
A group is created at \code{name} containing the contents of the DelayedSubassign.
}
\description{
Save a \linkS4class{DelayedSubassign} object into a HDF5 file.
See the \dQuote{Subset assignment} operation at \url{https://artifactdb.github.io/chihaya/} for more details.
}
\examples{
X <- DelayedArray(matrix(runif(100), ncol=20))
X[1:2,3:5] <- matrix(-runif(6), ncol=3)
temp <- tempfile(fileext=".h5")
saveDelayed(X, temp)
rhdf5::h5ls(temp)
loadDelayed(temp)

}
\author{
Aaron Lun
}
