% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_feature_on_embedding}
\alias{plot_feature_on_embedding}
\title{Plot Feature}
\usage{
plot_feature_on_embedding(
  object,
  embedding = c("UMAP", "PCA", "TSNE"),
  features,
  dims = c(1, 2),
  return_plotly = FALSE,
  ...
)
}
\arguments{
\item{object}{A SingleCellExperiment object}

\item{embedding}{Dimensional reduction technique to be used}

\item{features}{Feature to plot}

\item{dims}{Dimensions to plot, must be a two-length numeric vector}

\item{return_plotly}{return plotly object}

\item{...}{additional arguments passed to plotReduceDim}
}
\value{
an embedding colored by a feature of interest
}
\description{
Plots gene or transcript expression overlaid on a given embedding.
}
\examples{

data(small_example_dataset)
plot_feature_on_embedding(small_example_dataset, embedding = "UMAP", 
features = "Gene_0001")

}
