% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_solution_table.R
\name{get_solution_table}
\alias{get_solution_table}
\title{Get summarised table of cnv solutions}
\usage{
get_solution_table(cnv_solutions)
}
\arguments{
\item{cnv_solutions}{cnvcalling result from function call_cnv.R}
}
\value{
Dataframe of solution table
}
\description{
Get summarised table of cnv solutions
}
\examples{
#'
### Loading example SampleBam file
example_file <-  system.file("extdata","example_patientcfDNA_SampleBam.RDS",package = "cfdnakit")
sample_bambin <- readRDS(example_file)
### Example PoN
PoN_rdsfile <- system.file("extdata","ex.PoN.rds",package = "cfdnakit")
pon_profiles <- readRDS(PoN_rdsfile)
sample_profile <- get_fragment_profile(sample_bambin,sample_id = "Patient1")

sample_zscore <- get_zscore_profile(sample_profile,pon_profiles)

sample_zscore_segment <- segmentByPSCB(sample_zscore)

sample_cnv <- call_cnv(sample_zscore_segment,sample_zscore, tfs=c(0.1,0.3),ploidies=c(1.5,2), MaxCN=3)
get_solution_table(sample_cnv)
}
