% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_fragment_profile.R
\name{get_fragment_profile}
\alias{get_fragment_profile}
\title{Getting fragment-length information}
\usage{
get_fragment_profile(
  readbam_bin,
  sample_id,
  genome = "hg19",
  short_range = c(100, 150),
  long_range = c(151, 250),
  maximum_length = 600,
  minimum_length = 20
)
}
\arguments{
\item{readbam_bin}{SampleBam Object}

\item{sample_id}{Character; Given sample ID}

\item{genome}{abbreviation of reference genome; namely hg19, mm10. default:hg19}

\item{short_range}{Vector of 2 Int; Range of fragment length to be defined as short fragment; Default c(100,150)}

\item{long_range}{Vector of 2 Int; Range of fragment length to be defined as long fragment; Default c(151,250)}

\item{maximum_length}{Int; Maximum length of fragment. cfDNA fragment longer than this value will not be considered; Default 600}

\item{minimum_length}{Int; Minimum length of fragment. cfDNA fragment shorter than this value will not be considered;  Default 20}
}
\value{
SampleFragment Object; Fragment length information for quality check and downstream analysis per bin and summary of sample
}
\description{
Getting fragment-length information
}
\examples{
example_file <-  system.file("extdata","example_patientcfDNA_SampleBam.RDS",package = "cfdnakit")
sample_bambin <- readRDS(example_file)
sample_profile <- get_fragment_profile(sample_bambin,sample_id = "Patient1")
}
