\name{get_violins}
\alias{get_violins}
\title{Generate violin plots for treatment group comparisons}
\description{
  This function generates violin plots for comparing posterior distributions 
  of treatment group effects on cell migration.
}
\usage{
  get_violins(x, from_groups, to_group, exponentiate)
}
\arguments{
  \item{x}{An object generated by \code{cellmig}.}
  \item{from_groups}{A vector of group names to compare against the 
  target group.}
  \item{to_group}{A single group name serving as the reference for 
  comparisons.}
  \item{exponentiate}{logical, should the effect be exponentiating turning
log-fold-changes into more interpretable fold-changes}
}
\details{
  The function extracts posterior samples of treatment group-level means and 
  computes differences between specified groups. It generates a violin plot 
  illustrating these differences and returns both the computed data and the 
  plot object.
}
\value{
  A list with two elements:
  \item{ds}{A data frame containing computed differences, treatment group 
  identifiers, and associated statistics.}
  \item{plot}{A ggplot2 object representing the violin plot of the computed
  treatment differences.}
}
\examples{
data(d_mini, package = "cellmig")
o <- cellmig(x = d_mini,
             control = list(mcmc_warmup = 200,
                            mcmc_steps = 500,
                            mcmc_chains = 2,
                            mcmc_cores = 2,
                            mcmc_algorithm = "NUTS",
                            adapt_delta = 0.8,
                            max_treedepth = 10))
                            
str(get_groups(x = o))
u <- get_violins(x = o, 
                 from_groups = c("C2|D3", "C2|D4"),
                 to_group = "C3|D3",
                 exponentiate = FALSE)
}
\seealso{
  \code{cellmig}, \code{get_pairs}, \code{get_groups}
}
