% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_classes.R, R/all_methods_v3.R
\docType{class}
\name{trackedCells-class}
\alias{trackedCells-class}
\alias{trackedCells}
\alias{initialize,trackedCells-method}
\title{The trackedCells Class.}
\usage{
\S4method{initialize}{trackedCells}(.Object, x)
}
\arguments{
\item{.Object}{the trackedCells object being built}

\item{x}{imported TIFF image data}
}
\value{
An S4-class object

a trackedCells object
}
\description{
An S4 class to represent a set of cells whose movements were
tracked
over time.
}
\section{Slots}{

\describe{
\item{\code{images}}{is a list of imported images}

\item{\code{proc_images}}{is a list of processed images}

\item{\code{ops}}{is a list keeping track of the operations executed on
the object}

\item{\code{optimized}}{is a list including results of the params
auto-optimization (optional)}

\item{\code{centroids}}{is a list of detected centroids}

\item{\code{positions}}{is a data.frame of cell positions across stacks}

\item{\code{tracks}}{is a numeric matrix of cell tracks}

\item{\code{params}}{is a list of parameters used for the analysis}

\item{\code{stats}}{is a list of stats computed for the cell tracks}

\item{\code{metadata}}{is a list including labels about the image, and
the experiment}
}}

\author{
Damiano Fantini \email{damiano.fantini@gmail.com}
}
