% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions_v8.R
\name{aggregateTrackedCells}
\alias{aggregateTrackedCells}
\title{Aggregate trackedCells Objects}
\usage{
aggregateTrackedCells(
  x,
  ...,
  meta_id_field = c("tiff_file", "experiment", "condition", "replicate")
)
}
\arguments{
\item{x}{a \code{trackedCells}-class object where cells have
already
been tracked}

\item{...}{one or more trackedCells-class object(s) where cells
have already been tracked}

\item{meta_id_field}{string, can take one of the following values,
c("tiff_file", "experiment", "condition", "replicate"). Indicates
the meta-data column used as unique ID for the image/experiment.
Can be abbreviated. Defaults to "tiff_file".}
}
\value{
An aggregate data.frame including all cells that were
tracked over two or more images/experiments.
The data.frame includes the following columns: "new.ID",
"frame.ID",
"X", "Y", "cell.ID", "tiff_name",
"experiment", "condition", "replicate". The "new.ID" uniquely
identifies a cell in a given image/experiment.
}
\description{
Aggregate two or more trackedCells-class objects together.
Input objects must carry information of cell
tracks (otherwise an error will be raised). All tracks form
the different experiments/images are returned in a
large data.frame. A new unique ID is assigned to specifically
identify each cell track from each image/experiment.
}
\details{
each trackedCells-class object passed to this function
requires a unique identifier (such as a unique
tiff_file name). Any of the metadata columns can be used as
unique ID for an image/experiment. The function
will raise an error if non-unique identifiers are found across
the input objects.
}
\examples{
# Please, see the package vignette
# for an example of how to use this function.
# A pseudo-code example is shown below
# Let x0, x1, x2, ... be trackedCells-class objects
# with a non-empty tracks slot.
x0 <- get(data(TrackCellsDataset))
x0 <- setCellsMeta(x0, experiment = "my_exp_01", condition = "CTRL")
x1 <- setCellsMeta(x0, experiment = "my_exp_01", condition = "DMSO")
x2 <- setCellsMeta(x0, experiment = "my_exp_01", condition = "DRUG")
y <- aggregateTrackedCells(x0, x1, x2, meta_id_field = "condition")
utils::head(y, 50)


}
\references{
\url{https://www.data-pulse.com/dev_site/cellmigration/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
