% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions_v8.R
\name{Prep4OptimizeParams}
\alias{Prep4OptimizeParams}
\title{Prepare For Parameter Optimization}
\usage{
Prep4OptimizeParams(
  stack_img,
  lnoise_range = NULL,
  min.px.diam = 5,
  diameter_range = NULL,
  threshold_range = NULL,
  target_cell_num = NULL,
  quantile.val = NULL,
  px.margin = NULL,
  plot = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{stack_img}{input image}

\item{lnoise_range}{numeric, lnoise values to test}

\item{min.px.diam}{numeric, minimum number of pixels of a cell signal}

\item{diameter_range}{numeric, numeric values for diameter}

\item{threshold_range}{numeric, numeric values for threshold}

\item{target_cell_num}{numeric, target number of cells, can be NULL}

\item{quantile.val}{numeric, the quantile prob used to suppress noise}

\item{px.margin}{numeric, the frame margin size}

\item{plot}{logical, shall a plot be printed}

\item{verbose}{logical, shall info be printed to console}
}
\value{
a data frame of combined parameters to be tested
}
\description{
Pre-processing as part of the Optimization Parameter process
}
\details{
This is an internal function supporting the Optimization Parameter
steps
}
\examples{
x <- get(data(TrackCellsDataset))
x <- cellmigRation::getCellImages(x = x)
y <- cellmigRation:::Prep4OptimizeParams(stack_img = x)
y$success

}
\keyword{internal}
