% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions_v8.R
\name{FMI}
\alias{FMI}
\title{Forward Migration Index}
\usage{
FMI(object, TimeInterval = 10, export = FALSE, ExpName = NULL)
}
\arguments{
\item{object}{\code{CellMig} class object, which is a list of
data frames resulted from the PreProcessing.}

\item{TimeInterval}{A numeric value of the time elapsed between
successive frames in the time-lapse stack.}

\item{export}{if `TRUE` (default), exports function output to
CSV file}

\item{ExpName}{string, name of the experiment. Can be NULL}
}
\value{
An CellMig class Object with a data frame. The data
frame is stored in the FMItable slot.
}
\description{
The FMI function automatically generates data for
the forward migration index
}
\examples{
data(WSADataset)
wasDF=WSADataset[seq(1,300,by=1),]
wsaTD <- CellMig(wasDF)
wsaTD <- wsaPreProcessing(wsaTD,FrameN=55)
wsaTD <-FMI(wsaTD,TimeInterval=10, export=FALSE)

}
\references{
\url{https://www.data-pulse.com/dev_site/cellmigration/}
}
\author{
Salim Ghannoum \email{salim.ghannoum@medisin.uio.no}
}
