% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions_v8.R
\name{DiAutoCor}
\alias{DiAutoCor}
\title{Direction AutoCorrelation}
\usage{
DiAutoCor(
  object,
  TimeInterval = 10,
  sLAG = 0.25,
  sPLOT = TRUE,
  aPLOT = TRUE,
  export = FALSE,
  ExpName = NULL
)
}
\arguments{
\item{object}{\code{CellMig} class object, which is a list of
data frames resulted from the PreProcessing.}

\item{TimeInterval}{A numeric value of the time elapsed between
successive frames in the time-lapse stack.}

\item{sLAG}{A numeric value to be used to get the number of lags
for the slope fitting. Default is 0.25, which represents 25
percent of the steps.}

\item{sPLOT}{A logical vector that allows generating individual
plots showing the angular persistence across several sequantial
time intervals. Default is TRUE.}

\item{aPLOT}{A logical vector that allows generating a plot
showing the angular persistence across several sequantial time
intervals of all cells. Default is TRUE.}

\item{export}{if `TRUE` (default), exports function output to CSV
file}

\item{ExpName, }{string, name of the experiment. Can be NULL}
}
\value{
An CellMig class Object with a data frame and plots.
The data frame, which contains six rows: "Cell Number",
"Angular Persistence", "Intercept of DA quadratic model",
"Mean Direction AutoCorrelation (all lags)",
"Stable Direction AutoCorrelation through the track" and
"Difference between Mean DA and Intercept DA".
}
\description{
The DiAutoCor function automatically compute the
angular persistence across several sequantial time intervals.
}
\examples{


data(TrajectoryDataset)
rmDF=TrajectoryDataset[seq(1,220,by=1),]
rmTD <- CellMig(rmDF)
rmTD <- rmPreProcessing(rmTD,FrameN=55)
rmTD <- DiAutoCor(rmTD, TimeInterval=10, sLAG=0.25, sPLOT=FALSE,
                  aPLOT=FALSE, export=FALSE)

}
\references{
\url{https://www.data-pulse.com/dev_site/cellmigration/}
}
\author{
Salim Ghannoum \email{salim.ghannoum@medisin.uio.no}
}
