% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions_v8.R
\name{ComputeTracksStats}
\alias{ComputeTracksStats}
\title{Compute Tracks Stats}
\usage{
ComputeTracksStats(tc_obj, time_between_frames, resolution_pixel_per_micron)
}
\arguments{
\item{tc_obj}{a \code{trackedCells} object}

\item{time_between_frames}{integer, time interval between two
successive frames were taken}

\item{resolution_pixel_per_micron}{integer, image resolution,
i.e. number of pixels per micron}
}
\value{
a trackedCells object, including cell track statistics
}
\description{
Wrapper for the MigrationStats() function. It computes statistics
for a
trackedCells object where cells have already been tracked.
}
\examples{
x <- get(data(TrackCellsDataset))
x <- ComputeTracksStats(x, time_between_frames = 10,
                        resolution_pixel_per_micron = 20)
getCellsStats(x)


}
\references{
\url{https://www.data-pulse.com/dev_site/cellmigration/}
\url{https://www.mathworks.com/matlabcentral/fileexchange/60349-fasttracks}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
