% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/celdaUMAP.R
\name{celdaUmap}
\alias{celdaUmap}
\alias{celdaUmap,SingleCellExperiment-method}
\title{Uniform Manifold Approximation and Projection (UMAP) dimension
 reduction for celda \code{sce} object}
\usage{
celdaUmap(
  sce,
  useAssay = "counts",
  altExpName = "featureSubset",
  maxCells = NULL,
  minClusterSize = 100,
  modules = NULL,
  seed = 12345,
  nNeighbors = 30,
  minDist = 0.75,
  spread = 1,
  pca = TRUE,
  initialDims = 50,
  normalize = "proportion",
  scaleFactor = NULL,
  transformationFun = sqrt,
  cores = 1,
  ...
)

\S4method{celdaUmap}{SingleCellExperiment}(
  sce,
  useAssay = "counts",
  altExpName = "featureSubset",
  maxCells = NULL,
  minClusterSize = 100,
  modules = NULL,
  seed = 12345,
  nNeighbors = 30,
  minDist = 0.75,
  spread = 1,
  pca = TRUE,
  initialDims = 50,
  normalize = "proportion",
  scaleFactor = NULL,
  transformationFun = sqrt,
  cores = 1,
  ...
)
}
\arguments{
\item{sce}{A \link[SingleCellExperiment]{SingleCellExperiment} object
returned by \link{celda_C}, \link{celda_G}, or \link{celda_CG}.}

\item{useAssay}{A string specifying which \link{assay}
slot to use. Default "counts".}

\item{altExpName}{The name for the \link{altExp} slot
to use. Default "featureSubset".}

\item{maxCells}{Integer. Maximum number of cells to plot. Cells will be
randomly subsampled if \code{ncol(sce) > maxCells}. Larger numbers of cells
requires more memory. If NULL, no subsampling will be performed.
Default NULL.}

\item{minClusterSize}{Integer. Do not subsample cell clusters below this
threshold. Default 100.}

\item{modules}{Integer vector. Determines which features modules to use for
UMAP. If NULL, all modules will be used. Default NULL.}

\item{seed}{Integer. Passed to \link[withr]{with_seed}. For reproducibility,
a default value of 12345 is used. If NULL, no calls to
\link[withr]{with_seed} are made.}

\item{nNeighbors}{The size of local neighborhood used for
manifold approximation. Larger values result in more global
views of the manifold, while smaller values result in more
local data being preserved. Default 30.
See \link[uwot]{umap} for more information.}

\item{minDist}{The effective minimum distance between embedded points.
Smaller values will result in a more clustered/clumped
embedding where nearby points on the manifold are drawn
closer together, while larger values will result on a more
even dispersal of points. Default 0.75.
See \link[uwot]{umap} for more information.}

\item{spread}{The effective scale of embedded points. In combination with
\code{min_dist}, this determines how clustered/clumped the
 embedded points are. Default 1. See \link[uwot]{umap} for more information.}

\item{pca}{Logical. Whether to perform
dimensionality reduction with PCA before UMAP. Only works for celda_C
\code{sce} objects.}

\item{initialDims}{Integer. Number of dimensions from PCA to use as
input in UMAP. Default 50. Only works for celda_C \code{sce} objects.}

\item{normalize}{Character. Passed to \link{normalizeCounts} in
normalization step. Divides counts by the library sizes for each
cell. One of 'proportion', 'cpm', 'median', or 'mean'. 'proportion' uses
the total counts for each cell as the library size. 'cpm' divides the
library size of each cell by one million to produce counts per million.
'median' divides the library size of each cell by the median library size
across all cells. 'mean' divides the library size of each cell by the mean
library size across all cells.}

\item{scaleFactor}{Numeric. Sets the scale factor for cell-level
normalization. This scale factor is multiplied to each cell after the
library size of each cell had been adjusted in \code{normalize}. Default
\code{NULL} which means no scale factor is applied.}

\item{transformationFun}{Function. Applys a transformation such as 'sqrt',
'log', 'log2', 'log10', or 'log1p'. If \code{NULL}, no transformation will
be applied. Occurs after applying normalization and scale factor. Default
\code{NULL}.}

\item{cores}{Number of threads to use. Default 1.}

\item{...}{Additional parameters to pass to \link[uwot]{umap}.}
}
\value{
\code{sce} with UMAP coordinates
 (columns "celda_UMAP1" & "celda_UMAP2") added to
 \code{\link{reducedDim}(sce, "celda_UMAP")}.
}
\description{
Embeds cells in two dimensions using \link[uwot]{umap} based on
 a celda model. For celda_C \code{sce} objects, PCA on the normalized counts
 is used to reduce the number of features before applying UMAP. For celda_CG
 \code{sce} object, UMAP is run on module probabilities to reduce the number
 of features instead of using PCA. Module probabilities are square-root
 transformed before applying UMAP.
}
\examples{
data(sceCeldaCG)
umapRes <- celdaUmap(sceCeldaCG)
}
