\name{ccrepe}
\alias{ccrepe}
\title{
 Calculates compositionality-corrected p-values and q-values for compositional data using an arbitrary distance metric.
}
\description{

    ccrepe calculates compositionality-corrected p-values and q-values for compositional data by generating
	first a null distribution of the distance metric generated by permutation and renormalization of the data,
	and then by generating an alternative distribution of the distance metric by bootstrap resampling of the data.
        For greater detail, see References\cr
	The two distributions are compared using a pooled-variance Z-test to give a compositionality-corrected p-value.
        The p-values can be calculated for all appropriate (passing certain quality-control measures) pairwise comparisons,
        or for a subset of user-specified ones.\cr
        Q-values are additionally calculated using the Benjamin-Hochberg-Yekutieli procedure (see References)
		
 }
\usage{
 ccrepe(
 x = NA,
 y = NA,
 sim.score = cor,
 sim.score.args = list(),
 min.subj = 20,
 iterations = 1000,
 subset.cols.x = NULL,				 
 subset.cols.y = NULL, 
 errthresh  = 1e-04,
 verbose = FALSE,
 iterations.gap = 100,
 distributions = NA,
 compare.within.x = TRUE,
 concurrent.output = NA,
 make.output.table = FALSE)
 
}
\arguments{
  \item{x}{
   First dataframe or matrix containing the relative abundances in cavity1 : columns are bugs, rows are samples.
   (Rows should therefore sum to a constant.)\cr
   The subjectIDs, if present, are assumed to be the row names and NOT the first column of data.\cr 
}
  \item{y}{
   Second dataframe or matrix (optional) containing the relative abundances in cavity2: columns are bugs, rows are samples. \cr
   The subjectIDs, if present, are assumed to be the row names.
   If both x and y are specified, they will be merged by row names.  If no row names are specified for either or both datasets,
   the default is to use the row numbers as subject IDs.
}
 
  \item{sim.score}{
   A function defining a similarity measure, such as cor or nc.score.  This similarity measure can be a pre-defined R function or user-defined.  If the latter,
   certain properties should be satisfied as detailed below (also see examples).  The default similarity measure is Spearman correlation.\cr
   A user-defined similarity measure should:\cr
   1.Be able to take either two inputs which are vectors or one input which is either a matrix or a dataframe\cr
   2.In the case of two inputs, return a single number\cr
   3.In the case of one input, return a matrix in which the (i,j)th entry is the similarity score for column i and column j in the original matrix\cr
   4.Resulting matrix (in the case of one input) must be symmetric\cr
   5.The inputs must be named x and y\cr
}
  \item{sim.score.args}{
	A list of arguments for the measurement function.
	For example:  In the case of cor, the following would be acceptable:
	sim.score.args = list(method='spearman',use='complete.obs'	).\cr	
}
  \item{min.subj}{
  Minimum number of samples that must be non-missing in a bug/feature/column in order to apply the similarity measure
  to that bug/feature/column.  This is to ensure that there are sufficient subjects to perform a bootstrap (default: 20).
}
  \item{iterations}{
  The number of iterations of bootstrap and permutation (default: 1000).
}
  \item{subset.cols.x}{
  A vector of column indices from x to indicate which features to compare
}
 \item{subset.cols.y}{
  A vector of column indices from y to indicate which features to compare  
}
  \item{errthresh}{
       If feature has number of zeros greater than  errthresh^(1/n)  , that feature is excluded 
}

  
  \item{verbose}{
	Logical: an indicator whether the user requested verbose output, which prints periodic progress of the algorithm through the dataset(s),
        as well as including more detailed output.  (default:FALSE)
}
 \item{iterations.gap}{
	If output is verbose - number of iterations after issue a status message (Default=100 - displayed only if verbose=TRUE).
}
  \item{distributions}{
	Output Distribution file  (default:NA).
}
  \item{compare.within.x}{
        A boolean value indicating whether to do comparisons given by
	taking all subsets of size 2 from subset.cols.x or to do
	comparisons given by taking all possible combinations of
	subset.cols.x or subset.cols.y. If TRUE but subset.cols.y=NA,
	returns all comparisons involving any features in subset.cols.x.  This argument is only used when y=NA.
}
\item{concurrent.output}{
       Optional output file to which each comparison will be written as
	it is calculated.
}
\item{make.output.table}{
  A boolean value indicating whether to include table-formatted output.
}      
}
 
\value{
	Returns a list containing the calculation results and the parameters used.\cr
	Default parameters shown:\cr
        \item{min.subj}{Description above}
	\item{errThresh}{Description same as errthresh above}
	\item{sim.score}{A matrix of the simliarity scores for all the requested comparisons.  The (i,j)th
        element of sim.score correponds to the similarity score of column i (or the ith column of subset.cols.1) 
        and column j (or the jth column of subset.cols.1) in one dataset, or
        to the similarity score of column i (or the ith column of subset.cols.1) in dataset x 
        and column j (or the jth column of subset.cols.2)in dataset y in the case of two datasets.}
	\item{p.values}{A  matrix of the p-values for all the requested comparisons.  The (i,j)th element of p.values
        corresponds to the p-value of the (i,j)th element of sim.score.}
	\item{q.values}{A matrix of the Benjamini-Hochberg-Yekutieli FDR corrected p-values.  The (i,j)th element
        of q.values corresponds to the q-value fo the (i,j)th element of
	sim.score.}
        \item{z.stat}{A matrix of the z-statistics for all the
	  requested comparisons.  The (i,j)th element corresponds	
	  to the z-statistic which gave rise to the (i,j)th p-value.}
        \item{output.table}{(Only if make.output.table=TRUE) A table
	where each row is one comparision.  Each row contains the
	features being compared with their similarity scores,
	z-statistics, p-values and q-values}
        Additional parameters if verbose=TRUE:
	\item{iterations}{Description Above}
	\item{subset.cols.x}{Description Above}
	\item{subset.cols.y}{Description Above}
	\item{iterations.gap}{Description Above}
	\item{sim.score.parameters}{Description Above}
	\item{compare.within.x}{Description Above}
	\item{make.output.table}{Description Above}

}
\author{
  Emma Schwager <emma.schwager@gmail.com> 
}
\examples{
data <- matrix(rlnorm(40,meanlog=0,sdlog=1),nrow=10)
data.rowsum <- apply(data,1,sum)
data.norm <- data/data.rowsum
testdata <- data.norm
dimnames(testdata) <- list(paste("Sample",seq(1,10)),paste("Feature",seq(1,4)))
ccrepe.results  <-ccrepe  (x=testdata, iterations=20, min.subj=10)
ccrepe.results.nc.score <- ccrepe(x=testdata,iterations=20,min.subj=10,sim.score=nc.score)
ccrepe.results
ccrepe.results.nc.score
}

\references{


  Emma Schwager and Colleagues. Detecting statistically significant
  associtations between sparse and high dimensional compositioanl
  data. In Progress.

  Benjamini and Yekutieli (2001).  "The control of the false discovery rate in multiple testing under dependency." The Annals of Statistics.  Vol. 19, No. 4.  pp. 1165-1188.


}
