% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{read_10x}
\alias{read_10x}
\title{Read 10x data and generate scNMF object}
\usage{
read_10x(dir, count = "matrix.mtx", genes = "genes.tsv",
  barcodes = "barcodes.tsv", remove.zeros = TRUE)
}
\arguments{
\item{dir}{Name of directory containing data files.}

\item{count}{Name of count matrix file.}

\item{genes}{Name of gene annotation file.}

\item{barcodes}{Name of cell annotation file.}

\item{remove.zeros}{If \code{TRUE}, empty rows/columns are 
removed.}
}
\value{
Object of class \code{scNMFSet}
}
\description{
Read count, gene, and barcode annotation data in 10x format 
and create an object of class \code{scNMFSet}.
}
\details{
Files for \code{count}, \code{genes}, and \code{barcodes} are
assumed to be present in \code{dir}. 
Count data are in sparse "Matrix Market" format 
(\url{https://math.nist.gov/MatrixMarket/formats.html}).
}
\examples{
library(S4Vectors)
s <- scNMFSet(count=matrix(rpois(n=12,lambda=3),4,3))
rowData(s) <- DataFrame(seq_len(4))
colData(s) <- DataFrame(seq_len(3))
write_10x(s,dir='.')
s <- read_10x(dir='.')
s
}
