% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scNMF_class.R
\name{measure}
\alias{measure}
\title{Factorization measures in an Object}
\usage{
measure(object)
}
\arguments{
\item{object}{Object of class \code{scNMFSet}.}
}
\value{
Either \code{NULL} or a data frame containing measures.
}
\description{
Retrieve or set factorization measures in an object
}
\details{
Factorization under multiple rank values lead to measures stored in
a data frame inside a slot \code{measure}. In maximum likelihood using
\code{\link{factorize}}, this set of quality measures include 
dispersion and cophenetic
coeeficients for each rank. In Bayesian factorization using 
\code{\link{vb_factorize}},
log evidence for each rank is stored. \code{measure(object)} 
will return the data
frame. \code{measure(object) <- value}
can be used to modify it.
}
\examples{
s <- scNMFSet(count=matrix(rpois(n=12,lambda=3),4,3))
s <- vb_factorize(s,ranks=seq(2,4))
measure(s)
}
