% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{doSVD}
\alias{doSVD}
\title{Perform Truncated Singular Value Decomposition (SVD)}
\usage{
doSVD(x, svdMaxRatio = 0.08, nCeil = 2000, nCores)
}
\arguments{
\item{x}{A numeric matrix to perform SVD on.}

\item{svdMaxRatio}{(Optional) The maximum proportion of singular vectors
used for generating subsets (default: \code{0.08}).}

\item{nCeil}{(Optional) The maximum number of cells used to compute the
proportion of singular vectors (default: \code{2000}).}

\item{nCores}{The number of cores to use for parallel processing.}
}
\value{
A matrix containing the right singular vectors of `x`.
}
\description{
Computes a truncated SVD on a matrix using the implicitly restarted 
Lanczos bidiagonalization algorithm (IRLBA).
}
\details{
This function utilizes the `irlba` function from the `irlba` 
package to efficiently calculate the truncated SVD of the input matrix `x`. 
The returned matrix contains `nv` right singular vectors, which are often
used for dimensionality reduction and feature extraction in various
applications.
}
\examples{
library(scater)
library(splatter)

sce <- splatSimulate(group.prob = rep(1, 5)/5, sparsify = FALSE, 
        batchCells=100, nGenes=1000, method = "groups", verbose = FALSE, 
        dropout.type = "experiment")
sce <- logNormCounts(sce)
cores <- 2
logX <- as.matrix(logcounts(sce))
w <- rowVars_fast(logX, cores)
corMat <- getCorM("spearman", logcounts(sce), w, cores)
v <- doSVD(corMat, nCores=cores)

}
