% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{ccImpute}
\alias{ccImpute}
\alias{ccImpute.SingleCellExperiment}
\alias{ccImpute,SingleCellExperiment-method}
\title{Impute Dropout Values in Single-Cell RNA Sequencing Data}
\usage{
ccImpute.SingleCellExperiment(
  object,
  dist,
  nCeil = 2000,
  svdMaxRatio = 0.08,
  maxSets = 8,
  k,
  consMin = 0.75,
  kmNStart,
  kmMax = 1000,
  fastSolver = TRUE,
  BPPARAM = bpparam(),
  verbose = TRUE
)

ccImpute(
  object,
  dist,
  nCeil = 2000,
  svdMaxRatio = 0.08,
  maxSets = 8,
  k,
  consMin = 0.75,
  kmNStart,
  kmMax = 1000,
  fastSolver = TRUE,
  BPPARAM = bpparam(),
  verbose = TRUE
)

\S4method{ccImpute}{SingleCellExperiment}(
  object,
  dist,
  nCeil = 2000,
  svdMaxRatio = 0.08,
  maxSets = 8,
  k,
  consMin = 0.75,
  kmNStart,
  kmMax = 1000,
  fastSolver = TRUE,
  BPPARAM = bpparam(),
  verbose = TRUE
)
}
\arguments{
\item{object}{A \code{SingleCellExperiment} class object containing the
scRNA-seq data. The \code{logcounts} assay should contain matrix with
log-normalized expression values. This code supports both dense and sparse
(dgCMatrix) matrix format storage.}

\item{dist}{(Optional) A distance matrix used for cell similarity.
calculations. If not provided, a weighted Spearman correlation matrix is
calculated.}

\item{nCeil}{(Optional) The maximum number of cells used to compute the
proportion of singular vectors (default: \code{2000}).}

\item{svdMaxRatio}{(Optional) The maximum proportion of singular vectors
used for generating subsets (default: \code{0.08}).}

\item{maxSets}{(Optional) The maximum number of sub-datasets used for
consensus clustering (default: \code{8}).}

\item{k}{(Optional) The number of clusters (cell groups) in the data. If not
provided, it is estimated using the Tracy-Widom Bound.}

\item{consMin}{(Optional) The low-pass filter threshold for processing the
consensus matrix (default: \code{0.75}).}

\item{kmNStart}{nstart parameter passed to \code{\link[stats]{kmeans}}.
function. Can be set manually. By default it is \code{1000} for up to
\code{2000} cells and \code{50} for more than \code{2000} cells.}

\item{kmMax}{iter.max parameter passed to \code{\link[stats]{kmeans}}.}

\item{fastSolver}{(Optional) Whether to use mean of
non-zero values for calculating dropout values or a linear equation solver
(much slower and did show empirical difference in imputation performance)
(default: \code{TRUE}).}

\item{BPPARAM}{(Optional) A \code{BiocParallelParam} object for parallel
processing (default: \code{bpparam()}).}

\item{verbose}{(Optional) Whether to print progress messages
(default: \code{TRUE}).}
}
\value{
A \code{SingleCellExperiment} class object with the imputed
expression values stored in the `"imputed"` assay.
}
\description{
Performs imputation of dropout values in single-cell RNA sequencing
(scRNA-seq) data using a consensus clustering-based algorithm (ccImpute). 
This implementation includes performance enhancements over the original
ccImpute method described in the paper "ccImpute: an accurate and scalable
consensus clustering based algorithm to impute dropout events in the
single-cell RNA-seq data" (DOI: https://doi.org/10.1186/s12859-022-04814-8).

Defines the generic function `ccImpute` and a specific method for
`SingleCellExperiment` objects.
}
\examples{
library(BiocParallel)
library(splatter)
library(scater)
sce <- splatSimulate(group.prob = rep(1, 5)/5, sparsify = FALSE, 
        batchCells=100, nGenes=1000, method = "groups", verbose = FALSE, 
        dropout.type = "experiment")
sce <- logNormCounts(sce)
cores <- 2
BPPARAM = MulticoreParam(cores)
sce <- ccImpute(sce, BPPARAM=BPPARAM)

}
