% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbaf-obtainOneStudy.R
\name{obtainOneStudy}
\alias{obtainOneStudy}
\title{Obtain the requested data for various subgroups of a cancer study.}
\usage{
obtainOneStudy(genesList, submissionName, studyName, desiredTechnique,
  desiredCaseList = FALSE, validateGenes = TRUE)
}
\arguments{
\item{genesList}{a list that contains at least one gene group}

\item{submissionName}{a character string containing name of interest. It is
used for naming the process.}

\item{studyName}{a character string showing the desired cancer name. It is an
standard cancer study name that can be found on cbioportal.org, such as
\code{"Acute Myeloid Leukemia (TCGA, NEJM 2013)"}.}

\item{desiredTechnique}{a character string that is one of the following
techniques: \code{"RNA-Seq"}, \code{"RNA-SeqRTN"}, \code{"microRNA-Seq"},
\code{"microarray.mRNA"}, \code{"microarray.microRNA"} or
\code{"methylation"}.}

\item{desiredCaseList}{a numeric vector that contains the index of desired
cancer subgroups, assuming the user knows index of desired subgroups. If not,
 desiredCaseList is set to \code{"none"}, function will show the available
 subgroups and ask the user to enter the desired ones during the
 process. The default value is \code{"none"}.}

\item{validateGenes}{a logical value that, if set to be 'TRUE', causes the
function to check each cancer study to find whether or not each gene has a
record. If a cancer doesn't have a record for specific gene, function looks
for alternative gene names that cbioportal might use instead of the given
gene name.}
}
\value{
a BiocFileCach object that contains the obtained data without further
 processing. Name of the object is combination of `bfc_` and submissionName.
 Inside it, there is a section for the obtained data, which is stored as a
 list. At first level, this list is subdivided into diferent groups based on
 the list of genes that user has given the function, then each gene group
 itself contains one matrix for every study subgroup. Additonally, if
 validateGenes = TRUE, another section that contains gene validation results
 will be created in the BiocFileCach object.
}
\description{
This function Obtains the requested data for the given genes
across multiple subgroups of a cancer. It can check whether or not all genes
are included in subgroups of a cancer study and, if not, looks for the
alternative gene names.
}
\details{
\tabular{lllll}{
Package: \tab cbaf \cr
Type: \tab Package \cr
Version: \tab 1.31.1 \cr
Date: \tab 2025-10-26 \cr
License: \tab Artistic-2.0 \cr
}
}
\examples{
genes <- list(K.demethylases = c("KDM1A", "KDM1B", "KDM2A", "KDM2B", "KDM3A",
 "KDM3B", "JMJD1C", "KDM4A"), K.methyltransferases = c("SUV39H1", "SUV39H2",
 "EHMT1", "EHMT2", "SETDB1", "SETDB2", "KMT2A", "KMT2A"))

obtainOneStudy(genes, "test", "Breast Invasive Carcinoma (TCGA, Cell 2015)",
"RNA-Seq", desiredCaseList = c(2,3,4,5))



}
\author{
Arman Shahrisa, \email{shahrisa.arman@hotmail.com} [maintainer,
copyright holder]

Maryam Tahmasebi Birgani, \email{tahmasebi-ma@ajums.ac.ir}
}
